/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.spicej.streams;

import at.borkowski.spicej.shapers.RateShaper;
import at.borkowski.spicej.streams.RateHelper;
import at.borkowski.spicej.ticks.TickSource;
import java.io.IOException;
import java.io.OutputStream;

public class RateLimitOutputStream
extends OutputStream
implements RateShaper {
    private final OutputStream real;
    private int bytesPerTick;
    private final RateHelper rateHelper;

    public RateLimitOutputStream(OutputStream real, TickSource tickSource, int byteRate, int prescale) {
        this.real = real;
        this.bytesPerTick = byteRate;
        this.rateHelper = new RateHelper(tickSource, byteRate, prescale);
    }

    @Override
    public void setByteRate(int bytesPerTick) {
        this.bytesPerTick = bytesPerTick;
    }

    @Override
    public void write(int b) throws IOException {
        this.rateHelper.takeOne();
        this.real.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        for (int done = 0; done < len; done += this.realWrite(b, off + done, Math.min(len - done, this.bytesPerTick))) {
        }
    }

    private int realWrite(byte[] b, int off, int len) throws IOException {
        int lenToWrite = this.rateHelper.take(len);
        this.real.write(b, off, lenToWrite);
        return lenToWrite;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void close() throws IOException {
        this.real.close();
        this.rateHelper.close();
    }

    @Override
    public void flush() throws IOException {
        this.real.flush();
    }

    void test__SetIdleNotify(RateHelper.IdleNotify target) {
        this.rateHelper.test__SetIdleNotify(target);
    }

    public void setNonBlocking(boolean nonBlocking) {
        this.rateHelper.setNonBlocking(nonBlocking);
    }
}

