/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.spicej.streams;

import at.borkowski.spicej.WouldBlockException;
import at.borkowski.spicej.impl.SleepWakeup;
import at.borkowski.spicej.ticks.TickListener;
import at.borkowski.spicej.ticks.TickSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class DelayedInputStream
extends InputStream
implements TickListener {
    private final InputStream in;
    private final long delay;
    private final byte[] buffer;
    private boolean blocking = true;
    private long currentTick;
    private volatile int currentVirtualEnd = 0;
    private volatile int start = 0;
    private volatile int end = 0;
    private SortedSet<Long> tickMarks = new TreeSet<Long>();
    private Map<Long, Integer> tick_virtualEnd = new HashMap<Long, Integer>();
    private SleepWakeup sleep = new SleepWakeup();
    private Object lock = new Object();

    public DelayedInputStream(TickSource t, InputStream in, long delay, int bufferSize) {
        this.in = in;
        this.delay = delay;
        this.buffer = new byte[bufferSize + 1];
        t.addListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        if (this.delay == 0L) {
            this.handleNewData();
        }
        this.waitForAvailable();
        Object object = this.lock;
        synchronized (object) {
            byte b = this.buffer[this.start++];
            if (this.start >= this.buffer.length) {
                this.start -= this.buffer.length;
            }
            return b & 0xFF;
        }
    }

    private void waitForAvailable() {
        while (this.bufferedBytes(this.currentVirtualEnd) == 0) {
            if (!this.blocking) {
                throw new WouldBlockException();
            }
            this.sleep.sleep();
        }
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int ret;
        if (this.delay == 0L) {
            this.handleNewData();
        }
        this.waitForAvailable();
        int readable = this.bufferedBytes(this.currentVirtualEnd);
        int toRead = ret = Math.min(len, readable);
        if (this.start + toRead > this.buffer.length) {
            int chunk1 = this.buffer.length - this.start;
            System.arraycopy(this.buffer, this.start, b, off, chunk1);
            toRead -= chunk1;
            off += chunk1;
            this.start = 0;
        }
        System.arraycopy(this.buffer, this.start, b, off, toRead);
        Object object = this.lock;
        synchronized (object) {
            this.start += toRead;
            if (this.start >= this.buffer.length) {
                this.start -= this.buffer.length;
            }
        }
        return ret;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    int bufferedBytes() {
        return this.bufferedBytes(this.end);
    }

    int bufferedBytes(int effectiveEnd) {
        if (this.start == effectiveEnd) {
            return 0;
        }
        if (this.start < effectiveEnd) {
            return effectiveEnd - this.start;
        }
        return effectiveEnd - this.start + this.buffer.length;
    }

    int freeBytes() {
        return this.buffer.length - this.bufferedBytes() - 1;
    }

    @Override
    public void tick(long tick) {
        this.currentTick = tick;
        this.handleNewData();
    }

    @Override
    public int available() throws IOException {
        if (this.delay == 0L) {
            this.handleNewData();
        }
        return this.bufferedBytes(this.currentVirtualEnd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNewData() {
        try {
            int previousEnd = this.end;
            if (this.in.available() > 0 && this.freeBytes() > 0) {
                int rd;
                int toRead = Math.min(this.freeBytes(), this.in.available());
                while (toRead > 0 && (rd = this.in.read(this.buffer, this.end, Math.min(toRead, this.buffer.length - this.end))) != -1) {
                    toRead -= rd;
                    Object object = this.lock;
                    synchronized (object) {
                        this.end += rd;
                        if (this.end >= this.buffer.length) {
                            this.end -= this.buffer.length;
                        }
                        if (this.end != previousEnd && this.delay > 0L) {
                            this.tick_virtualEnd.put(this.currentTick + this.delay - 1L, this.end);
                            this.tickMarks.add(this.currentTick + this.delay - 1L);
                        }
                    }
                }
            }
            this.sleep.wakeup();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        while (!this.tickMarks.isEmpty() && this.tickMarks.first() <= this.currentTick) {
            Long tick = this.tickMarks.first();
            this.tickMarks.remove(tick);
            this.currentVirtualEnd = this.tick_virtualEnd.remove(tick);
        }
        if (this.tickMarks.isEmpty()) {
            this.currentVirtualEnd = this.end;
        }
    }
}

