/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.scovillej.services.comm.impl;

import at.borkowski.scovillej.services.comm.Serializer;
import at.borkowski.scovillej.services.comm.SimulationSocket;
import at.borkowski.spicej.ticks.TickListener;
import at.borkowski.spicej.ticks.TickSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Queue;

public abstract class SimulationSocketImpl<T>
implements SimulationSocket<T> {
    private static final int HEADER_LENGTH = 4;
    private SimulationSocketImpl<T> otherSide;
    private Serializer<T> serializer;
    private final Queue<T> receiveQueue = new LinkedList<T>();
    private InputStream in;
    private OutputStream out;
    private boolean blockIsHeader = true;
    private byte[] nextBlock = new byte[4];
    private int nextBlockFilled = 0;
    private boolean open = false;
    private boolean finished = false;

    @Override
    public boolean established() {
        return this.open;
    }

    @Override
    public int available() throws IOException {
        this.readRemaining();
        return this.receiveQueue.size();
    }

    @Override
    public T read() throws IOException {
        this.readRemaining();
        return this.receiveQueue.poll();
    }

    @Override
    public void write(T object) throws IOException {
        byte[] serialized = this.serializer.serialize(object);
        byte[] header = this.createHeader(serialized);
        this.out.write(header);
        this.out.write(serialized);
    }

    @Override
    public void close() {
        super.closeInternal();
        this.closeInternal();
    }

    private void closeInternal() {
        this.open = false;
    }

    private void readRemaining() throws IOException {
        if (this.finished) {
            throw new IOException("socket closed");
        }
        if (this.in.available() == 0 && !this.open) {
            try {
                this.in.close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
            try {
                this.out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.finished = true;
            return;
        }
        while (this.nextBlock != null && this.nextBlockFilled < this.nextBlock.length && this.in.available() > 0) {
            this.nextBlockFilled += this.in.read(this.nextBlock, this.nextBlockFilled, this.nextBlock.length - this.nextBlockFilled);
            if (this.nextBlock == null || this.nextBlockFilled != this.nextBlock.length) continue;
            if (this.blockIsHeader) {
                this.nextBlock = new byte[ByteBuffer.wrap(this.nextBlock).getInt()];
            } else {
                this.receiveQueue.add(this.serializer.deserialize(this.nextBlock));
                this.nextBlock = new byte[4];
            }
            this.nextBlockFilled = 0;
            this.blockIsHeader = !this.blockIsHeader;
        }
    }

    byte[] createHeader(byte[] serialized) {
        return ByteBuffer.allocate(4).putInt(serialized.length).array();
    }

    protected void setIO(TickSource t, InputStream in, OutputStream out, SimulationSocketImpl<T> otherSide, Serializer<T> serializer) {
        this.in = in;
        this.out = out;
        this.otherSide = otherSide;
        this.serializer = serializer;
        this.open = true;
        t.addListener((TickListener)new AvailableUpdater());
    }

    private class AvailableUpdater
    implements TickListener {
        private AvailableUpdater() {
        }

        public void tick(long tick) {
            try {
                if (SimulationSocketImpl.this.open && !SimulationSocketImpl.this.finished) {
                    SimulationSocketImpl.this.readRemaining();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

