/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.scovillej.prefetch.profiling;

import at.borkowski.scovillej.prefetch.Request;
import at.borkowski.scovillej.prefetch.profiling.PrefetchProfilingResults;
import at.borkowski.scovillej.prefetch.profiling.PrefetchProfilingService;
import at.borkowski.scovillej.profile.Series;
import at.borkowski.scovillej.profile.SeriesResult;
import at.borkowski.scovillej.simulation.PhaseHandler;
import at.borkowski.scovillej.simulation.ServiceProvider;
import at.borkowski.scovillej.simulation.Simulation;
import at.borkowski.scovillej.simulation.SimulationEvent;
import at.borkowski.scovillej.simulation.SimulationInitializationContext;
import java.util.Collection;

public class PrefetchProfilingServiceImpl
implements PrefetchProfilingService,
PrefetchProfilingResults,
ServiceProvider<PrefetchProfilingService> {
    private static String URT = "prefetch-profiling-urt";
    private static String OVERDUE = "prefetch-profiling-overdue";
    private static String AGE = "prefetch-profiling-age";
    private static String MISS = "prefetch-profiling-miss";
    private static String URTperKB = "prefetch-profiling-urt-per-byte";
    private Simulation simulation;
    private Series<Long> seriesURT;
    private Series<Long> seriesOverdue;
    private Series<Long> seriesAge;
    private Series<Void> seriesMisses;
    private Series<Double> seriesURTperKB;

    public void initialize(Simulation simulation, SimulationInitializationContext context) {
        this.simulation = simulation;
        this.seriesURT = context.getSeries(URT, Long.class);
        this.seriesOverdue = context.getSeries(OVERDUE, Long.class);
        this.seriesAge = context.getSeries(AGE, Long.class);
        this.seriesMisses = context.getSeries(MISS, Void.class);
        this.seriesURTperKB = context.getSeries(URTperKB, Double.class);
    }

    public Collection<PhaseHandler> getPhaseHandlers() {
        return null;
    }

    public Collection<SimulationEvent> generateEvents() {
        return null;
    }

    public PrefetchProfilingService getService() {
        return this;
    }

    public Class<PrefetchProfilingService> getServiceClass() {
        return PrefetchProfilingService.class;
    }

    @Override
    public void fetched(Request request, int actualSize, long tick, long duration) {
        long overdue = this.simulation.getCurrentTick() - request.getDeadline();
        System.out.printf("%d - fetched %s (overdue %d) (%d B in %d t, %.2f B/t\n", tick, request.getFile(), overdue, actualSize, duration, (double)actualSize / (double)duration);
        overdue = Math.max(0L, overdue);
        this.seriesURT.measure((Object)overdue);
        this.seriesURTperKB.measure((Object)(1000.0 * (double)overdue / (double)request.getData()));
    }

    @Override
    public void cacheHit(Request request, long age) {
        System.out.printf("%d - cache hit for %s (age %d)\n", this.simulation.getCurrentTick(), request.getFile(), age);
        this.seriesAge.measure((Object)age);
    }

    @Override
    public void cacheMiss(Request request) {
        System.out.printf("%d - cache miss for %s\n", this.simulation.getCurrentTick(), request.getFile());
        this.seriesMisses.measure(null);
    }

    @Override
    public void lateArrival(Request request) {
        long overdue = this.simulation.getCurrentTick() - request.getDeadline();
        System.out.printf("%d - late arrival for %s (overdue %d)\n", this.simulation.getCurrentTick(), request.getFile(), overdue);
        this.seriesOverdue.measure((Object)overdue);
    }

    @Override
    public SeriesResult<Long> getCacheHitAges() {
        return this.simulation.getSeries(AGE, Long.class);
    }

    @Override
    public SeriesResult<Void> getCacheMisses() {
        return this.simulation.getSeries(MISS, Void.class);
    }

    @Override
    public SeriesResult<Long> getOverdue() {
        return this.simulation.getSeries(OVERDUE, Long.class);
    }

    @Override
    public SeriesResult<Long> getURT() {
        return this.simulation.getSeries(URT, Long.class);
    }

    @Override
    public SeriesResult<Double> getURTperKB() {
        return this.simulation.getSeries(URTperKB, Double.class);
    }
}

