/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.scovillej.prefetch.members.server;

import at.borkowski.scovillej.prefetch.members.server.ClientProcessor;
import at.borkowski.scovillej.prefetch.members.server.FileServerProcessor;
import at.borkowski.scovillej.prefetch.members.server.SocketProcessor;
import at.borkowski.scovillej.simulation.PhaseHandler;
import at.borkowski.scovillej.simulation.Simulation;
import at.borkowski.scovillej.simulation.SimulationContext;
import at.borkowski.scovillej.simulation.SimulationEvent;
import at.borkowski.scovillej.simulation.SimulationInitializationContext;
import at.borkowski.scovillej.simulation.SimulationMember;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class FetchServer
implements SimulationMember,
PhaseHandler {
    private final SocketProcessor socketProcessor;
    private final FileServerProcessor fileServerProcessor;
    private final List<ClientProcessor> clientProcessors = new LinkedList<ClientProcessor>();

    FetchServer(SocketProcessor socketProcessor, FileServerProcessor fileServerProcessor) {
        this.socketProcessor = socketProcessor;
        this.fileServerProcessor = fileServerProcessor;
    }

    public FetchServer(String socketName) {
        this.socketProcessor = new SocketProcessor(this, socketName);
        this.fileServerProcessor = new FileServerProcessor();
    }

    public void initialize(Simulation simulation, SimulationInitializationContext context) {
        this.socketProcessor.initialize(simulation, context);
    }

    public Collection<SimulationEvent> generateEvents() {
        return null;
    }

    public Collection<PhaseHandler> getPhaseHandlers() {
        return Arrays.asList(this);
    }

    public void executePhase(SimulationContext context) {
        try {
            this.socketProcessor.executePhase(context);
            if (this.clientProcessors.size() > 0) {
                this.clientProcessors.get((int)(context.getCurrentTick() % (long)this.clientProcessors.size())).handle(context);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public Collection<String> getPhaseSubcription() {
        return null;
    }

    public FileServerProcessor getFileServerProcessor() {
        return this.fileServerProcessor;
    }

    public void deregisterClientProcessor(ClientProcessor clientHandler) {
        this.clientProcessors.remove(clientHandler);
    }

    public void registerClientProcessor(ClientProcessor clientProcessor) {
        this.clientProcessors.add(clientProcessor);
    }
}

