/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.scovillej.prefetch.members.server;

import at.borkowski.scovillej.prefetch.members.server.FetchServer;
import at.borkowski.scovillej.services.comm.SimulationSocket;
import at.borkowski.scovillej.simulation.SimulationContext;
import java.io.IOException;

public class ClientProcessor {
    private final FetchServer owner;
    private final SimulationSocket<byte[]> socket;

    public ClientProcessor(FetchServer owner, SimulationSocket<byte[]> socket) {
        this.owner = owner;
        this.socket = socket;
    }

    public void handle(SimulationContext context) throws IOException {
        String request;
        if (this.socket.available() == 0) {
            return;
        }
        byte[] requestBytes = (byte[])this.socket.read();
        String string = request = requestBytes == null ? null : new String(requestBytes, "UTF8");
        if (request == null) {
            this.close();
        } else {
            this.handle(request, context);
        }
    }

    private void handle(String request, SimulationContext context) throws IOException {
        if (this.owner.getFileServerProcessor().hasFile(request)) {
            this.socket.write((Object)this.owner.getFileServerProcessor().getFile(request));
        } else {
            this.socket.write(null);
        }
    }

    private void close() {
        this.socket.close();
        this.owner.deregisterClientProcessor(this);
    }
}

