/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.scovillej.prefetch.members.client;

import at.borkowski.scovillej.services.comm.CommunicationService;
import at.borkowski.scovillej.services.comm.SimulationSocket;
import at.borkowski.scovillej.simulation.Simulation;
import at.borkowski.scovillej.simulation.SimulationContext;
import at.borkowski.scovillej.simulation.SimulationInitializationContext;
import java.io.IOException;

public class SocketProcessor {
    private final String socketName;
    private CommunicationService comm;
    private SimulationSocket<byte[]> socket;
    private boolean initialized = false;

    public SocketProcessor(String socketName) {
        this.socketName = socketName;
    }

    public void initialize(Simulation simulation, SimulationInitializationContext context) {
        this.comm = (CommunicationService)context.getService(CommunicationService.class);
    }

    public void executePhase(SimulationContext context) throws IOException {
        if (!this.initialized) {
            this.initialize(context);
        }
    }

    private void initialize(SimulationContext context) throws IOException {
        this.socket = this.comm.beginConnect(this.socketName, byte[].class);
        this.initialized = true;
    }

    public byte[] readIfPossible() throws IOException {
        if (this.socket.available() != 0) {
            return (byte[])this.socket.read();
        }
        return null;
    }

    public void request(String file) throws IOException {
        this.socket.write((Object)file.getBytes("UTF8"));
    }

    public boolean isReady() {
        return this.socket != null && this.socket.established();
    }
}

