/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.scovillej.prefetch.members.client;

import at.borkowski.scovillej.prefetch.Request;
import at.borkowski.scovillej.prefetch.algorithms.NullAlgorithm;
import at.borkowski.scovillej.prefetch.algorithms.PrefetchAlgorithm;
import at.borkowski.scovillej.prefetch.members.client.FetchClient;
import at.borkowski.scovillej.simulation.Simulation;
import at.borkowski.scovillej.simulation.SimulationContext;
import at.borkowski.scovillej.simulation.SimulationInitializationContext;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FetchProcessor {
    private final FetchClient owner;
    private final Set<Request> toFetch = new HashSet<Request>();
    private Map<Long, Request> scheduled = new HashMap<Long, Request>();
    private PrefetchAlgorithm algorithm = new NullAlgorithm();
    private long currentStart;
    private Request current = null;

    public FetchProcessor(FetchClient owner) {
        this.owner = owner;
    }

    public void executePhase(SimulationContext context) throws IOException {
        long tick = context.getCurrentTick();
        if (this.current != null) {
            byte[] payload = this.owner.getSocketProcessor().readIfPossible();
            if (payload != null) {
                long duration = tick - this.currentStart;
                this.owner.getProfilingService().fetched(this.current, payload.length, tick, duration);
                this.owner.getCacheProcessor().save(this.current.getFile(), payload, tick);
                this.current = null;
            }
        } else {
            long sel = tick;
            for (long lambda : this.scheduled.keySet()) {
                if (lambda > tick || lambda >= sel) continue;
                sel = lambda;
            }
            this.current = this.scheduled.remove(sel);
            if (this.current != null) {
                System.out.printf("%d -              requesting %s (%d, %d)\n", tick, this.current.getFile(), sel, this.current.getDeadline());
                this.owner.getSocketProcessor().request(this.current.getFile());
                this.currentStart = tick;
            }
        }
    }

    private void reschedule() {
        this.scheduled = this.algorithm.schedule(this.toFetch);
    }

    public void initialize(Simulation simulation, SimulationInitializationContext context) {
        this.reschedule();
    }

    public void addRequests(Collection<Request> requests) {
        this.toFetch.addAll(requests);
    }

    public void setAlgorithm(PrefetchAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    public void urge(long tick, Request request) {
        while (this.scheduled.containsKey(tick)) {
            --tick;
        }
        this.scheduled.put(tick, request);
    }

    public PrefetchAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public Set<Request> getPendingRequests() {
        return this.toFetch;
    }
}

