/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.scovillej.prefetch.members.client;

import at.borkowski.scovillej.prefetch.Request;
import at.borkowski.scovillej.prefetch.members.client.FetchClient;
import at.borkowski.scovillej.simulation.SimulationContext;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class ClientCodeProcessor {
    private final FetchClient owner;
    private Set<Request> required = new HashSet<Request>();
    private Set<Request> missed = new HashSet<Request>();

    public ClientCodeProcessor(FetchClient owner) {
        this.owner = owner;
    }

    public void executePhase(SimulationContext context) {
        long tick = context.getCurrentTick();
        HashSet<Request> done = new HashSet<Request>();
        for (Request request : this.required) {
            if (request.getDeadline() > tick) continue;
            if (this.owner.getCacheProcessor().hasFile(request.getFile())) {
                if (request.getDeadline() == tick) {
                    this.owner.getProfilingService().cacheHit(request, tick - this.owner.getCacheProcessor().getTimestamp(request.getFile()));
                } else {
                    this.owner.getProfilingService().lateArrival(request);
                }
                done.add(request);
                continue;
            }
            if (this.missed.contains(request)) continue;
            this.owner.getProfilingService().cacheMiss(request);
            this.owner.getFetchProcessor().urge(tick, request);
            this.missed.add(request);
        }
        this.required.removeAll(done);
    }

    public void addRequests(Collection<Request> requests) {
        this.required.addAll(requests);
    }
}

