/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.scovillej.prefetch.algorithms;

import at.borkowski.scovillej.prefetch.Request;
import at.borkowski.scovillej.prefetch.algorithms.PrefetchAlgorithm;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class IgnoreBlinkAlgorithm
implements PrefetchAlgorithm {
    public static final long CONNECTION_OVERHEAD = 5L;
    public static final double ALPHA = 1.0;

    @Override
    public Map<Long, Request> schedule(Set<Request> requests) {
        HashMap<Long, Request> ret = new HashMap<Long, Request>();
        LinkedList<Request> sortedByDeadline = new LinkedList<Request>(requests);
        Collections.sort(sortedByDeadline, new Comparator<Request>(){

            @Override
            public int compare(Request o1, Request o2) {
                return o1.getDeadline() > o2.getDeadline() ? -1 : 1;
            }
        });
        long previousStart = Long.MAX_VALUE;
        for (Request req : sortedByDeadline) {
            long start = this.getStart(previousStart, req);
            while (ret.containsKey(start)) {
                --start;
            }
            previousStart = start;
            ret.put(start, req);
        }
        return ret;
    }

    private long getStart(long busyUntil, Request req) {
        long required = (long)((double)req.getData() / req.getAvailableByterate()) + 1L;
        required += 5L;
        required = (long)((double)required / 1.0);
        return Math.min(busyUntil, req.getDeadline()) - required;
    }
}

