/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.scovillej.prefetch;

import at.borkowski.scovillej.SimulationBuilder;
import at.borkowski.scovillej.prefetch.Request;
import at.borkowski.scovillej.prefetch.algorithms.PrefetchAlgorithm;
import at.borkowski.scovillej.prefetch.members.aux.RateSetter;
import at.borkowski.scovillej.prefetch.members.client.FetchClient;
import at.borkowski.scovillej.prefetch.members.server.FetchServer;
import at.borkowski.scovillej.prefetch.profiling.PrefetchProfilingResults;
import at.borkowski.scovillej.prefetch.profiling.PrefetchProfilingServiceImpl;
import at.borkowski.scovillej.services.comm.CommunicationService;
import at.borkowski.scovillej.services.comm.CommunicationServiceBuilder;
import at.borkowski.scovillej.simulation.ServiceProvider;
import at.borkowski.scovillej.simulation.Simulation;
import at.borkowski.scovillej.simulation.SimulationMember;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public class PrefetchSimulationBuilder {
    private static final String RATE_PHASE = "rate";
    private static final String COMM_PHASE = "comm";
    private static final String SOCKET_NAME = "fetch";
    private static final long BASE_DELAY = 2L;
    private final FetchClient fetchClient;
    private final FetchServer fetchServer;
    private final PrefetchProfilingServiceImpl profilingService;
    private final ServiceProvider<CommunicationService> communicationService;
    private Map<Long, Integer> limits = null;
    private SimulationBuilder builder = new SimulationBuilder();
    private RateSetter rateSetter;

    public PrefetchSimulationBuilder() {
        this.builder.phase(RATE_PHASE);
        this.builder.phase("tick");
        this.builder.phase(COMM_PHASE);
        CommunicationServiceBuilder commBuilder = new CommunicationServiceBuilder().communicationPhase(COMM_PHASE).delay(SOCKET_NAME, Long.valueOf(2L));
        this.communicationService = commBuilder.create();
        this.builder.service(this.communicationService);
        this.profilingService = new PrefetchProfilingServiceImpl();
        this.builder.service((ServiceProvider)this.profilingService);
        this.fetchServer = new FetchServer(SOCKET_NAME);
        this.builder.member((SimulationMember)this.fetchServer);
        this.fetchClient = new FetchClient(SOCKET_NAME);
        this.builder.member((SimulationMember)this.fetchClient);
    }

    public Simulation create() {
        if (this.limits != null && !this.limits.isEmpty()) {
            this.rateSetter = new RateSetter(RATE_PHASE, (CommunicationService)this.communicationService.getService(), SOCKET_NAME, this.limits);
            this.builder.member((SimulationMember)this.rateSetter);
        }
        return this.builder.create();
    }

    public PrefetchSimulationBuilder limit(Integer byteRate) {
        ((CommunicationService)this.communicationService.getService()).setRates(SOCKET_NAME, byteRate, byteRate);
        return this;
    }

    public PrefetchSimulationBuilder limits(Map<Long, Integer> byteRates) {
        this.limits = byteRates;
        return this;
    }

    public PrefetchSimulationBuilder request(Request request) {
        this.fetchClient.addRequests(Arrays.asList(request));
        return this;
    }

    public PrefetchSimulationBuilder requests(Collection<Request> requests) {
        this.fetchClient.addRequests(requests);
        return this;
    }

    public PrefetchSimulationBuilder totalTicks(long tickCount) {
        this.builder.totalTicks(tickCount);
        return this;
    }

    public PrefetchSimulationBuilder files(Map<String, byte[]> files) {
        this.fetchServer.getFileServerProcessor().addFiles(files);
        return this;
    }

    public PrefetchSimulationBuilder algorithm(PrefetchAlgorithm algorithm) {
        this.fetchClient.getFetchProcessor().setAlgorithm(algorithm);
        return this;
    }

    public PrefetchProfilingResults getProfiling() {
        return this.profilingService;
    }

    FetchServer test__getFetchServer() {
        return this.fetchServer;
    }

    FetchClient test__getFetchClient() {
        return this.fetchClient;
    }

    ServiceProvider<CommunicationService> test__getCommunicationService() {
        return this.communicationService;
    }

    String test__getSocketName() {
        return SOCKET_NAME;
    }

    RateSetter test__getRateSetter() {
        return this.rateSetter;
    }
}

