/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.scovillej.impl.series;

import at.borkowski.scovillej.impl.series.DoubleSeriesImpl;
import at.borkowski.scovillej.impl.series.FloatSeriesImpl;
import at.borkowski.scovillej.impl.series.IntegerSeriesImpl;
import at.borkowski.scovillej.impl.series.LongSeriesImpl;
import at.borkowski.scovillej.impl.series.SeriesImpl;
import at.borkowski.scovillej.impl.series.VoidSeriesImpl;
import at.borkowski.scovillej.profile.SeriesProvider;
import at.borkowski.scovillej.simulation.Simulation;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public abstract class NumberSeriesImpl<T extends Number>
extends SeriesImpl<T> {
    private Simulation sim;
    private final Class<T> clazz;
    private final Map<Long, T> map = new HashMap<Long, T>();
    private final TreeSet<T> values;
    private Double sum = 0.0;
    protected long count = 0L;

    public NumberSeriesImpl(Comparator<T> comparator, Class<T> clazz) {
        this.clazz = clazz;
        this.values = new TreeSet<T>(comparator);
    }

    @Override
    public Class<T> getValueClass() {
        return this.clazz;
    }

    @Override
    public void initialize(Simulation sim) {
        this.sim = sim;
    }

    @Override
    public Map<Long, T> getAll() {
        return this.map;
    }

    @Override
    public Map<Long, Double> getAveraged(long classWidth) {
        long classes = (this.sim.getTotalTicks() + classWidth - 1L) / classWidth;
        HashMap<Long, Double> result = new HashMap<Long, Double>();
        for (long c = 0L; c < classes; ++c) {
            long start = c * classWidth;
            long end = c * classWidth + classWidth;
            LinkedList<T> values = new LinkedList<T>();
            for (long tick = start; tick < end; ++tick) {
                if (this.map.get(tick) == null) continue;
                values.add(this.map.get(tick));
            }
            if (values.size() == 0) {
                result.put(start, null);
                continue;
            }
            result.put(start, this.avg(values));
        }
        return result;
    }

    protected abstract T calcNativeMedian(T var1, T var2);

    private double avg(List<T> values) {
        double sum = 0.0;
        for (Number t : values) {
            sum += t.doubleValue();
        }
        return sum / (double)values.size();
    }

    @Override
    public void measure(T value) {
        if (this.map.containsKey(this.sim.getCurrentTick())) {
            throw new IllegalStateException("measurement for current tick already present");
        }
        this.map.put(this.sim.getCurrentTick(), value);
        this.values.add(value);
        this.sum = this.sum + ((Number)value).doubleValue();
        ++this.count;
    }

    @Override
    public Double getAverage() {
        if (this.count == 0L) {
            return null;
        }
        return this.sum / (double)this.count;
    }

    @Override
    public boolean hasSingleMedian() {
        return this.count % 2L == 1L;
    }

    protected T medianA() {
        if (this.count == 0L) {
            return null;
        }
        long l = this.hasSingleMedian() ? this.count / 2L : this.count / 2L - 1L;
        Iterator<T> iter = this.values.iterator();
        int i = 0;
        while ((long)i < l) {
            iter.next();
            ++i;
        }
        return (T)((Number)iter.next());
    }

    protected T medianB() {
        if (this.count == 0L) {
            return null;
        }
        long l = this.count / 2L;
        Iterator<T> iter = this.values.iterator();
        int i = 0;
        while ((long)i < l) {
            iter.next();
            ++i;
        }
        return (T)((Number)iter.next());
    }

    @Override
    public Double getDoubleMedian() {
        if (this.count == 0L) {
            return null;
        }
        return (((Number)this.medianA()).doubleValue() + ((Number)this.medianB()).doubleValue()) / 2.0;
    }

    @Override
    public Double getStandardDeviation() {
        if (this.count == 0L) {
            return null;
        }
        double devSum = 0.0;
        double avg = this.getAverage();
        for (Number d : this.values) {
            devSum += Math.pow(d.doubleValue() - avg, 2.0);
        }
        return Math.sqrt(devSum / (double)this.count);
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public T getMin() {
        if (this.count == 0L) {
            return null;
        }
        return (T)((Number)this.values.first());
    }

    @Override
    public T getMax() {
        if (this.count == 0L) {
            return null;
        }
        return (T)((Number)this.values.last());
    }

    @Override
    public T[] getNativeMedians() {
        if (this.count == 0L) {
            return null;
        }
        Number[] array = (Number[])Array.newInstance(this.clazz, this.hasSingleMedian() ? 1 : 2);
        array[0] = this.medianA();
        if (!this.hasSingleMedian()) {
            array[1] = this.medianB();
        }
        return array;
    }

    @Override
    public T getNativeMedian() {
        if (this.count == 0L) {
            return null;
        }
        if (this.hasSingleMedian() || this.medianA() == this.medianB()) {
            return this.medianA();
        }
        return this.calcNativeMedian(this.medianA(), this.medianB());
    }

    public static Collection<Class<?>> getKnownSeriesClasses() {
        return Arrays.asList(Double.class, Float.class, Integer.class, Long.class, Void.class);
    }

    public static <T> SeriesProvider<T> createIfKnown(Class<T> clazz) {
        if (clazz.equals(Double.class)) {
            return new DoubleSeriesImpl();
        }
        if (clazz.equals(Float.class)) {
            return new FloatSeriesImpl();
        }
        if (clazz.equals(Integer.class)) {
            return new IntegerSeriesImpl();
        }
        if (clazz.equals(Long.class)) {
            return new LongSeriesImpl();
        }
        if (clazz.equals(Void.class)) {
            return new VoidSeriesImpl();
        }
        return null;
    }

    @Override
    protected Formatter formatMetrics(Formatter f) {
        if (this.count == 0L) {
            return f;
        }
        return f.format("range [%10.2f .. %10.2f] avg %10.2f median %10.2f", ((Number)this.getMin()).doubleValue(), ((Number)this.getMax()).doubleValue(), this.getAverage(), this.getDoubleMedian());
    }
}

