/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.scovillej.impl;

import at.borkowski.scovillej.impl.series.NumberSeriesImpl;
import at.borkowski.scovillej.profile.Series;
import at.borkowski.scovillej.profile.SeriesProvider;
import at.borkowski.scovillej.profile.SeriesResult;
import at.borkowski.scovillej.simulation.PhaseHandler;
import at.borkowski.scovillej.simulation.ServiceProvider;
import at.borkowski.scovillej.simulation.Simulation;
import at.borkowski.scovillej.simulation.SimulationContext;
import at.borkowski.scovillej.simulation.SimulationEvent;
import at.borkowski.scovillej.simulation.SimulationMember;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SimulationImpl
implements Simulation {
    private final long totalTicks;
    private final List<String> phases;
    private final Collection<SimulationMember> members = new LinkedList<SimulationMember>();
    private final Map<String, List<PhaseHandler>> phaseToHandlers = new HashMap<String, List<PhaseHandler>>();
    private final Map<Long, List<SimulationEvent>> tickToEvents = new HashMap<Long, List<SimulationEvent>>();
    private final Map<String, SeriesProvider<?>> series;
    private final Set<ServiceProvider<?>> services;
    private final SimulationContext simulationContext;
    private long currentTick = 0L;
    private String currentPhase = null;
    private boolean done = false;

    public SimulationImpl(long totalTicks, List<String> phases, List<SimulationMember> members, Map<String, SeriesProvider<?>> series, Set<ServiceProvider<?>> services) {
        this.totalTicks = totalTicks;
        this.phases = phases;
        this.series = series;
        this.services = services;
        this.members.addAll(members);
        this.members.addAll(services);
        this.simulationContext = this.initializeContext();
        for (String string : phases) {
            this.phaseToHandlers.put(string, new LinkedList());
        }
        for (SeriesProvider seriesProvider : series.values()) {
            seriesProvider.initialize(this);
        }
        for (SimulationMember simulationMember : members) {
            simulationMember.initialize(this, this.simulationContext);
        }
        for (SimulationMember simulationMember : services) {
            simulationMember.initialize(this, this.simulationContext);
        }
        for (SimulationMember member : this.members) {
            Collection<SimulationEvent> memberEvents = member.generateEvents();
            if (memberEvents == null) continue;
            for (SimulationEvent event : memberEvents) {
                List<SimulationEvent> list = this.tickToEvents.get(event.getScheduledTick());
                if (list == null) {
                    list = new LinkedList<SimulationEvent>();
                    this.tickToEvents.put(event.getScheduledTick(), list);
                }
                list.add(event);
            }
        }
        for (SimulationMember member : this.members) {
            if (member.getPhaseHandlers() == null) continue;
            for (PhaseHandler handler : member.getPhaseHandlers()) {
                if (handler.getPhaseSubcription() != null) {
                    for (String phase : handler.getPhaseSubcription()) {
                        this.phaseToHandlers.get(phase).add(handler);
                    }
                    continue;
                }
                this.phaseToHandlers.get("tick").add(handler);
            }
        }
    }

    private SimulationContext initializeContext() {
        return new SimulationContext(){

            @Override
            public <T> Series<T> getSeries(String symbol, Class<T> clazz) {
                if (SimulationImpl.this.series.get(symbol) == null) {
                    SimulationImpl.this.series.put(symbol, SimulationImpl.this.createSeries(clazz));
                }
                if (!((SeriesProvider)SimulationImpl.this.series.get(symbol)).getValueClass().equals(clazz)) {
                    return null;
                }
                return (Series)SimulationImpl.this.series.get(symbol);
            }

            @Override
            public <T> T getService(Class<T> clazz) {
                return (T)SimulationImpl.this.lookup(clazz);
            }

            @Override
            public String getCurrentPhase() {
                return SimulationImpl.this.currentPhase;
            }

            @Override
            public long getCurrentTick() {
                return SimulationImpl.this.currentTick;
            }
        };
    }

    @Override
    public void executeToEnd() {
        if (this.done) {
            this.increaseTick();
        }
        while (this.currentTick < this.totalTicks) {
            this.executeTick();
            ++this.currentTick;
        }
        --this.currentTick;
    }

    @Override
    public void executeUpToTick(long tick) {
        if (this.done) {
            this.increaseTick();
        }
        if (tick >= this.totalTicks) {
            throw new IllegalArgumentException("tick >= tickCount");
        }
        if (tick <= this.currentTick) {
            throw new IllegalArgumentException("tick <= tickCount");
        }
        while (this.currentTick < tick) {
            this.executeTick();
            ++this.currentTick;
        }
        --this.currentTick;
    }

    private void executeTick() {
        Iterator<String> iterator = this.phases.iterator();
        while (iterator.hasNext()) {
            String phase;
            this.currentPhase = phase = iterator.next();
            if (this.tickToEvents.containsKey(this.currentTick)) {
                for (SimulationEvent event : this.tickToEvents.get(this.currentTick)) {
                    if ((event.getPhaseSubcription() == null || !event.getPhaseSubcription().contains(this.currentPhase)) && (event.getPhaseSubcription() != null || !this.currentPhase.equals("tick"))) continue;
                    this.handlePhase(event);
                }
            }
            for (PhaseHandler handler : this.phaseToHandlers.get(this.currentPhase)) {
                this.handlePhase(handler);
            }
        }
        this.done = true;
    }

    private void handlePhase(PhaseHandler handler) {
        handler.executePhase(this.simulationContext);
    }

    private SeriesProvider<?> createSeries(Class<?> clazz) {
        SeriesProvider<?> provider = NumberSeriesImpl.createIfKnown(clazz);
        if (provider != null) {
            provider.initialize(this);
        }
        return provider;
    }

    private <T> T lookup(Class<T> clazz) {
        for (ServiceProvider<?> o : this.services) {
            if (!clazz.isAssignableFrom(o.getServiceClass())) continue;
            return (T)o.getService();
        }
        return null;
    }

    @Override
    public void executeCurrentTick() {
        if (this.done) {
            throw new IllegalStateException("can't re-execute tick");
        }
        this.executeTick();
    }

    @Override
    public long getCurrentTick() {
        return this.currentTick;
    }

    @Override
    public void executeAndIncreaseTick() {
        if (this.done) {
            throw new IllegalStateException("can't re-execute tick");
        }
        this.executeTick();
        if (this.currentTick + 1L < this.totalTicks) {
            ++this.currentTick;
            this.done = false;
        }
    }

    @Override
    public void increaseTick() {
        this.increaseTick(false);
    }

    @Override
    public void increaseTickStrictly() {
        this.increaseTick(true);
    }

    private void increaseTick(boolean strict) {
        if (!this.done) {
            throw new IllegalStateException("can't skip tick");
        }
        if (this.currentTick + 1L < this.totalTicks) {
            ++this.currentTick;
            this.done = false;
        } else if (strict) {
            throw new IllegalStateException("can't advance past last tick");
        }
    }

    @Override
    public boolean executedCurrentTick() {
        return this.done;
    }

    @Override
    public long getTotalTicks() {
        return this.totalTicks;
    }

    @Override
    public <T> SeriesResult<T> getSeries(String symbol, Class<T> clazz) {
        if (this.series.get(symbol) == null) {
            return null;
        }
        if (!this.series.get(symbol).getValueClass().equals(clazz)) {
            return null;
        }
        return this.series.get(symbol);
    }

    public Map<Long, List<SimulationEvent>> test__getEventsMap() {
        return this.tickToEvents;
    }

    @Override
    public List<String> getPhases() {
        return this.phases;
    }
}

