/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.scovillej.impl.series;

import at.borkowski.scovillej.impl.series.SeriesImpl;
import at.borkowski.scovillej.profile.SeriesProvider;
import at.borkowski.scovillej.simulation.Simulation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public abstract class NumberSeriesImpl<T extends Number>
extends SeriesImpl<T>
implements SeriesProvider<T> {
    private Simulation sim;
    private long totalTicks;
    private Map<Long, T> map;
    private TreeSet<T> values;
    private Double sum = 0.0;
    private long count = 0L;

    @Override
    public void initialize(Simulation sim, long totalTicks) {
        this.sim = sim;
        this.totalTicks = totalTicks;
        this.map = new HashMap<Long, T>();
        this.values = this.createValueTreeSet();
    }

    @Override
    public Map<Long, T> getAll() {
        return this.map;
    }

    @Override
    public Map<Long, Double> getAveraged(long classWidth) {
        long classes = (this.totalTicks + classWidth - 1L) / classWidth;
        HashMap<Long, Double> result = new HashMap<Long, Double>();
        for (long c = 0L; c < classes; ++c) {
            long start = c * classWidth;
            long end = c * classWidth + classWidth;
            LinkedList<T> values = new LinkedList<T>();
            for (long tick = start; tick < end; ++tick) {
                if (this.map.get(tick) == null) continue;
                values.add(this.map.get(tick));
            }
            if (values.size() == 0) {
                result.put(start, null);
                continue;
            }
            result.put(start, this.avg(values));
        }
        return result;
    }

    protected abstract TreeSet<T> createValueTreeSet();

    protected abstract T calcNativeMedian(T var1, T var2, boolean var3);

    protected double avg(List<T> values) {
        double sum = 0.0;
        for (Number t : values) {
            sum += t.doubleValue();
        }
        return sum / (double)values.size();
    }

    @Override
    public void measure(T value) {
        if (this.map.containsKey(this.sim.getCurrentTick())) {
            throw new IllegalStateException("measurement for current tick already present");
        }
        this.map.put(this.sim.getCurrentTick(), value);
        this.values.add(value);
        this.sum = this.sum + ((Number)value).doubleValue();
        ++this.count;
    }

    @Override
    public Double getAverage() {
        if (this.count == 0L) {
            return null;
        }
        return this.sum / (double)this.count;
    }

    @Override
    public boolean hasExactMedian() {
        return this.count % 2L == 1L;
    }

    protected T medianA() {
        if (this.count == 0L) {
            return null;
        }
        long l = this.hasExactMedian() ? this.count / 2L : this.count / 2L - 1L;
        Iterator<T> iter = this.values.iterator();
        int i = 0;
        while ((long)i < l) {
            iter.next();
            ++i;
        }
        return (T)((Number)iter.next());
    }

    protected T medianB() {
        if (this.count == 0L) {
            return null;
        }
        long l = this.count / 2L;
        Iterator<T> iter = this.values.iterator();
        int i = 0;
        while ((long)i < l) {
            iter.next();
            ++i;
        }
        return (T)((Number)iter.next());
    }

    @Override
    public Double getDoubleMedian() {
        if (this.count == 0L) {
            return null;
        }
        return (((Number)this.medianA()).doubleValue() + ((Number)this.medianB()).doubleValue()) / 2.0;
    }

    @Override
    public Double getStandardDeviation() {
        if (this.count == 0L) {
            return null;
        }
        double devSum = 0.0;
        double avg = this.getAverage();
        for (Number d : this.values) {
            devSum += Math.pow(d.doubleValue() - avg, 2.0);
        }
        return Math.sqrt(devSum / (double)this.count);
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public T getMin() {
        if (this.count == 0L) {
            return null;
        }
        return (T)((Number)this.values.first());
    }

    @Override
    public T getMax() {
        if (this.count == 0L) {
            return null;
        }
        return (T)((Number)this.values.last());
    }

    @Override
    public T getNativeMedian() {
        if (this.count == 0L) {
            return null;
        }
        return this.calcNativeMedian(this.medianA(), this.medianB(), this.hasExactMedian());
    }
}

