/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.scovillej.impl;

import at.borkowski.scovillej.profile.Series;
import at.borkowski.scovillej.profile.SeriesProvider;
import at.borkowski.scovillej.profile.SeriesResult;
import at.borkowski.scovillej.simulation.PhaseHandler;
import at.borkowski.scovillej.simulation.ServiceProvider;
import at.borkowski.scovillej.simulation.Simulation;
import at.borkowski.scovillej.simulation.SimulationContext;
import at.borkowski.scovillej.simulation.SimulationEvent;
import at.borkowski.scovillej.simulation.SimulationMember;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SimulationImpl
implements Simulation {
    private final long totalTicks;
    private final List<String> phases;
    private final Collection<SimulationMember> members = new LinkedList<SimulationMember>();
    private final Map<Long, Map<String, List<SimulationEvent>>> phaseToEvents;
    private final Map<String, SeriesProvider<?>> series;
    private final Set<ServiceProvider<?>> services;
    private long currentTick = -1L;
    private boolean done = false;

    public SimulationImpl(long totalTicks, List<String> phases, List<SimulationMember> members, Collection<SimulationEvent> events, Map<String, SeriesProvider<?>> series, Set<ServiceProvider<?>> services) {
        this.totalTicks = totalTicks;
        this.phases = phases;
        this.series = series;
        this.services = services;
        this.members.addAll(members);
        this.phaseToEvents = new HashMap<Long, Map<String, List<SimulationEvent>>>();
        for (SimulationEvent simulationEvent : events) {
            List<SimulationEvent> list;
            Map<String, List<SimulationEvent>> map = this.phaseToEvents.get(simulationEvent.getScheduledTick());
            if (map == null) {
                map = new HashMap<String, List<SimulationEvent>>();
                this.phaseToEvents.put(simulationEvent.getScheduledTick(), map);
            }
            if ((list = map.get(simulationEvent.getScheduledPhase())) == null) {
                list = new LinkedList<SimulationEvent>();
                map.put(simulationEvent.getScheduledPhase(), list);
            }
            list.add(simulationEvent);
        }
        for (SeriesProvider seriesProvider : series.values()) {
            seriesProvider.initialize(this, totalTicks);
        }
        for (ServiceProvider serviceProvider : services) {
            this.members.addAll(serviceProvider.getMembers());
        }
    }

    @Override
    public void executeToEnd() {
        if (this.currentTick == -1L) {
            throw new IllegalStateException("not initialized");
        }
        if (this.done) {
            this.increaseTick();
        }
        while (this.currentTick < this.totalTicks) {
            this.executeTick();
            ++this.currentTick;
        }
        --this.currentTick;
    }

    @Override
    public void executeUpToTick(long tick) {
        if (this.currentTick == -1L) {
            throw new IllegalStateException("not initialized");
        }
        if (this.done) {
            this.increaseTick();
        }
        if (tick >= this.totalTicks) {
            throw new IllegalArgumentException("tick >= tickCount");
        }
        if (tick <= this.currentTick) {
            throw new IllegalArgumentException("tick <= tickCount");
        }
        while (this.currentTick < tick) {
            this.executeTick();
            ++this.currentTick;
        }
        --this.currentTick;
    }

    private void executeTick() {
        for (String currentPhase : this.phases) {
            if (this.phaseToEvents.containsKey(this.currentTick) && this.phaseToEvents.get(this.currentTick).containsKey(currentPhase)) {
                this.handleEventPhase(currentPhase, (Collection<SimulationEvent>)this.phaseToEvents.get(this.currentTick).get(currentPhase));
            }
            this.handleMemberPhase(currentPhase, this.members);
        }
        this.done = true;
    }

    private void handleEventPhase(String currentPhase, Collection<SimulationEvent> events) {
        for (SimulationEvent event : events) {
            this.handlePhase(currentPhase, event);
        }
    }

    private void handleMemberPhase(String currentPhase, Collection<SimulationMember> members) {
        for (SimulationMember member : members) {
            this.handlePhase(currentPhase, member);
        }
    }

    private void handlePhase(final String currentPhase, PhaseHandler handler) {
        handler.executePhase(new SimulationContext(){

            @Override
            public String getCurrentPhase() {
                return currentPhase;
            }

            @Override
            public long getCurrentTick() {
                return SimulationImpl.this.currentTick;
            }

            @Override
            public <T extends Number> Series<T> getSeries(String symbol) {
                return (Series)SimulationImpl.this.series.get(symbol);
            }

            @Override
            public <T> T getService(Class<T> clazz) {
                return (T)SimulationImpl.this.lookup(clazz);
            }
        });
    }

    private <T> T lookup(Class<T> clazz) {
        for (ServiceProvider<?> o : this.services) {
            if (!clazz.isAssignableFrom(o.getServiceClass())) continue;
            return (T)o.getService();
        }
        return null;
    }

    @Override
    public void initialize() {
        if (this.currentTick != -1L) {
            throw new IllegalStateException("already initialized");
        }
        this.currentTick = 0L;
    }

    @Override
    public void executeCurrentTick() {
        if (this.currentTick == -1L) {
            throw new IllegalStateException("not initialized");
        }
        if (this.done) {
            throw new IllegalStateException("can't re-execute tick");
        }
        this.executeTick();
    }

    @Override
    public long getCurrentTick() {
        if (this.currentTick == -1L) {
            throw new IllegalStateException("not initialized");
        }
        return this.currentTick;
    }

    @Override
    public void executeAndIncreaseTick() {
        if (this.currentTick == -1L) {
            throw new IllegalStateException("not initialized");
        }
        if (this.done) {
            throw new IllegalStateException("can't re-execute tick");
        }
        this.executeTick();
        ++this.currentTick;
        this.done = false;
    }

    @Override
    public void increaseTick() {
        this.increaseTick(false);
    }

    @Override
    public void increaseTickStrictly() {
        this.increaseTick(true);
    }

    private void increaseTick(boolean strict) {
        if (this.currentTick == -1L) {
            throw new IllegalStateException("not initialized");
        }
        if (!this.done) {
            throw new IllegalStateException("can't skip tick");
        }
        if (this.currentTick + 1L < this.totalTicks) {
            ++this.currentTick;
            this.done = false;
        } else if (strict) {
            throw new IllegalStateException("can't advance past last tick");
        }
    }

    @Override
    public boolean finishedCurrentTick() {
        return this.done;
    }

    @Override
    public long getTotalTicks() {
        return this.totalTicks;
    }

    @Override
    public <T extends Number> SeriesResult<T> getSeries(String symbol) {
        return this.series.get(symbol);
    }

    public Map<Long, Map<String, List<SimulationEvent>>> test__getMap() {
        return this.phaseToEvents;
    }

    public List<String> test__getPhases() {
        return this.phases;
    }
}

