/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.scovillej;

import at.borkowski.scovillej.impl.SimulationImpl;
import at.borkowski.scovillej.impl.series.DoubleSeriesImpl;
import at.borkowski.scovillej.impl.series.FloatSeriesImpl;
import at.borkowski.scovillej.impl.series.IntegerSeriesImpl;
import at.borkowski.scovillej.impl.series.LongSeriesImpl;
import at.borkowski.scovillej.profile.SeriesProvider;
import at.borkowski.scovillej.simulation.ServiceProvider;
import at.borkowski.scovillej.simulation.Simulation;
import at.borkowski.scovillej.simulation.SimulationEvent;
import at.borkowski.scovillej.simulation.SimulationMember;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SimulationBuilder {
    private final List<String> phases = new LinkedList<String>();
    private final List<SimulationMember> members = new LinkedList<SimulationMember>();
    private final Map<String, SeriesProvider<?>> series = new HashMap();
    private final Set<ServiceProvider<?>> services = new HashSet();
    private Long tickCount;

    public SimulationBuilder() {
        this.phases.add("tick");
    }

    public SimulationBuilder totalTicks(long tickCount) {
        this.tickCount = tickCount;
        return this;
    }

    public SimulationBuilder phase(String phase) {
        this.phases.remove(phase);
        this.phases.add(phase);
        return this;
    }

    public SimulationBuilder member(SimulationMember member) {
        this.members.add(member);
        return this;
    }

    public SimulationBuilder seriesDouble(String symbol) {
        this.series.put(symbol, new DoubleSeriesImpl());
        return this;
    }

    public SimulationBuilder seriesFloat(String symbol) {
        this.series.put(symbol, new FloatSeriesImpl());
        return this;
    }

    public SimulationBuilder seriesLong(String symbol) {
        this.series.put(symbol, new LongSeriesImpl());
        return this;
    }

    public SimulationBuilder seriesInteger(String symbol) {
        this.series.put(symbol, new IntegerSeriesImpl());
        return this;
    }

    public SimulationBuilder service(ServiceProvider<?> service) {
        this.services.add(service);
        return this;
    }

    public Simulation create() {
        if (this.tickCount == null) {
            throw new IllegalStateException("tick count not set");
        }
        LinkedList<SimulationEvent> events = new LinkedList<SimulationEvent>();
        for (SimulationMember member : this.members) {
            Collection<SimulationEvent> tmp = member.generateEvents();
            if (tmp == null) continue;
            events.addAll(tmp);
        }
        return new SimulationImpl(this.tickCount, this.phases, this.members, events, this.series, this.services);
    }
}

