/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.prefetchsimulation.members.server;

import at.borkowski.prefetchsimulation.internal.VirtualPayload;
import at.borkowski.prefetchsimulation.members.server.ClientProcessor;
import at.borkowski.prefetchsimulation.members.server.FetchServer;
import at.borkowski.scovillej.services.comm.CommunicationService;
import at.borkowski.scovillej.services.comm.SimulationServerSocket;
import at.borkowski.scovillej.services.comm.SimulationSocket;
import at.borkowski.scovillej.simulation.Simulation;
import at.borkowski.scovillej.simulation.SimulationContext;
import at.borkowski.scovillej.simulation.SimulationInitializationContext;
import java.io.IOException;

public class SocketProcessor {
    private final FetchServer owner;
    private final String socketName;
    private CommunicationService comm;
    private SimulationServerSocket<VirtualPayload> serverSocket;
    private boolean initialized = false;

    public SocketProcessor(FetchServer owner, String socketName) {
        this.owner = owner;
        this.socketName = socketName;
    }

    public void initialize(Simulation simulation, SimulationInitializationContext context) {
        this.comm = (CommunicationService)context.getService(CommunicationService.class);
    }

    public void executePhase(SimulationContext context) throws IOException {
        if (!this.initialized) {
            this.initialize(context);
        }
        if (this.serverSocket.available() > 0) {
            this.owner.registerClientProcessor(new ClientProcessor(this.owner, (SimulationSocket<VirtualPayload>)this.serverSocket.accept()));
        }
    }

    private void initialize(SimulationContext context) throws IOException {
        this.serverSocket = this.comm.createServerSocket(this.socketName, VirtualPayload.class);
        this.initialized = true;
    }
}

