/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.prefetchsimulation.members.aux;

import at.borkowski.prefetchsimulation.members.aux.RateControlService;
import at.borkowski.scovillej.services.comm.CommunicationService;
import at.borkowski.scovillej.simulation.PhaseHandler;
import at.borkowski.scovillej.simulation.ServiceProvider;
import at.borkowski.scovillej.simulation.Simulation;
import at.borkowski.scovillej.simulation.SimulationContext;
import at.borkowski.scovillej.simulation.SimulationEvent;
import at.borkowski.scovillej.simulation.SimulationInitializationContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class RateSetter
implements ServiceProvider<RateControlService>,
RateControlService {
    private CommunicationService communicationService;
    private final String socketName;
    private List<SimulationEvent> events = new LinkedList<SimulationEvent>();
    private Integer requestSpecific;
    private Integer global;

    public RateSetter(final String phase, String socketName, Map<Long, Integer> limits) {
        this.socketName = socketName;
        for (final Long tick : limits.keySet()) {
            final Integer limit = limits.get(tick);
            this.events.add(new SimulationEvent(){

                public Collection<String> getPhaseSubcription() {
                    return Arrays.asList(phase);
                }

                public void executePhase(SimulationContext context) {
                    RateSetter.this.global = limit;
                    RateSetter.this.refreshRates();
                }

                public long getScheduledTick() {
                    return tick;
                }
            });
        }
    }

    public void initialize(Simulation simulation, SimulationInitializationContext context) {
        this.communicationService = (CommunicationService)context.getService(CommunicationService.class);
    }

    public Collection<SimulationEvent> generateEvents() {
        return this.events;
    }

    public Collection<PhaseHandler> getPhaseHandlers() {
        return null;
    }

    @Override
    public void setRequestSpecificRate(Integer requestSpecific) {
        this.requestSpecific = requestSpecific;
        this.refreshRates();
    }

    private void refreshRates() {
        Integer uplink;
        Integer downlink = uplink = this.global;
        if (this.requestSpecific != null && (this.global == null || this.global > this.requestSpecific)) {
            downlink = this.requestSpecific;
        }
        this.communicationService.setRates(this.socketName, uplink, downlink);
    }

    public Class<RateControlService> getServiceClass() {
        return RateControlService.class;
    }

    public RateControlService getService() {
        return this;
    }
}

