/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.prefetchsimulation.configuration.distributions;

import at.borkowski.prefetchsimulation.configuration.distributions.Distribution;
import at.borkowski.prefetchsimulation.util.RandomSource;

public class UniformLongDistribution
implements Distribution<Long> {
    private final long min;
    private final long max;
    private final long span;

    public UniformLongDistribution(long min, long max) {
        this.min = min;
        this.max = max;
        this.span = max - min;
    }

    @Override
    public Long getValue(RandomSource randomSource) {
        if (this.span == 0L) {
            return this.min;
        }
        long r = (randomSource.nextLong() % this.span + this.span) % this.span;
        return this.min + r;
    }

    @Override
    public Long getMean() {
        return this.min + (this.max - this.min) / 2L;
    }
}

