/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.prefetchsimulation.configuration.distributions;

import at.borkowski.prefetchsimulation.configuration.distributions.Distribution;
import at.borkowski.prefetchsimulation.util.RandomSource;

public class NormalIntegerDistribution
implements Distribution<Integer> {
    private final int mean;
    private final int sd;

    public NormalIntegerDistribution(int mean, int sd) {
        this.mean = mean;
        this.sd = sd;
    }

    @Override
    public Integer getValue(RandomSource randomSource) {
        if (this.sd == 0) {
            return this.mean;
        }
        return (int)(randomSource.nextGaussian() * (double)this.sd + (double)this.mean);
    }

    @Override
    public Integer getMean() {
        return this.mean;
    }
}

