/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.prefetchsimulation.configuration.distributions;

import at.borkowski.prefetchsimulation.configuration.distributions.Distribution;
import at.borkowski.prefetchsimulation.configuration.distributions.ExactDistribution;
import at.borkowski.prefetchsimulation.configuration.distributions.NormalDoubleDistribution;
import at.borkowski.prefetchsimulation.configuration.distributions.NormalIntegerDistribution;
import at.borkowski.prefetchsimulation.configuration.distributions.NormalLongDistribution;
import at.borkowski.prefetchsimulation.configuration.distributions.UniformDoubleDistribution;
import at.borkowski.prefetchsimulation.configuration.distributions.UniformIntegerDistribution;
import at.borkowski.prefetchsimulation.configuration.distributions.UniformLongDistribution;

public class Distributions {
    public static <T extends Number> Distribution<T> exact(T value) {
        return new ExactDistribution<T>(value);
    }

    public static Distribution<Integer> uniform(int min, int max) {
        return new UniformIntegerDistribution(min, max);
    }

    public static Distribution<Long> uniform(long min, long max) {
        return new UniformLongDistribution(min, max);
    }

    public static Distribution<Double> uniform(double min, double max) {
        return new UniformDoubleDistribution(min, max);
    }

    public static Distribution<Long> uniformLong(long min, long max) {
        return Distributions.uniform(min, max);
    }

    public static Distribution<Integer> uniformInteger(int min, int max) {
        return Distributions.uniform(min, max);
    }

    public static Distribution<Long> normal(long mean, long sd) {
        return new NormalLongDistribution(mean, sd);
    }

    public static Distribution<Integer> normal(int mean, int sd) {
        return new NormalIntegerDistribution(mean, sd);
    }

    public static Distribution<Double> normal(double mean, double sd) {
        return new NormalDoubleDistribution(mean, sd);
    }

    public static <T extends Number> Distribution<T> uniform(T min, T max, Class<T> clazz) {
        if (clazz.equals(Integer.class)) {
            return Distributions.uniform((Integer)min, (Integer)max);
        }
        if (clazz.equals(Long.class)) {
            return Distributions.uniform((Long)min, (Long)max);
        }
        if (clazz.equals(Double.class)) {
            return Distributions.uniform((Double)min, (Double)max);
        }
        throw new RuntimeException("unknown parse class " + clazz);
    }

    public static <T extends Number> Distribution<T> normal(T min, T max, Class<T> clazz) {
        if (clazz.equals(Integer.class)) {
            return Distributions.normal((Integer)min, (Integer)max);
        }
        if (clazz.equals(Long.class)) {
            return Distributions.normal((Long)min, (Long)max);
        }
        if (clazz.equals(Double.class)) {
            return Distributions.normal((Double)min, (Double)max);
        }
        throw new RuntimeException("unknown parse class " + clazz);
    }
}

