/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.prefetchsimulation.configuration;

import at.borkowski.prefetchsimulation.Request;
import at.borkowski.prefetchsimulation.algorithms.NullAlgorithm;
import at.borkowski.prefetchsimulation.algorithms.PrefetchAlgorithm;
import at.borkowski.prefetchsimulation.configuration.Configuration;
import at.borkowski.prefetchsimulation.configuration.ConfigurationException;
import at.borkowski.prefetchsimulation.configuration.RequestSeries;
import at.borkowski.prefetchsimulation.configuration.distributions.Distribution;
import at.borkowski.prefetchsimulation.configuration.distributions.Distributions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class ConfigurationReader {
    private final BufferedReader input;
    public static final String CMD_SEED = "seed";
    public static final String CMD_TOTAL_TICKS = "ticks";
    public static final String CMD_BYTERATE = "byterate";
    public static final String CMD_SLOT_LENGTH = "slot-length";
    public static final String CMD_NETWORK_UPTIME = "network-uptime";
    public static final String CMD_RELATIVE_JITTER = "relative-jitter";
    public static final String CMD_ABSOLUTE_JITTER = "absolute-jitter";
    public static final String CMD_REL_PREDICTION_TIME_ERROR = "relative-prediction-time-error";
    public static final String CMD_REL_PREDICTION_AMPLITUDE_ERROR = "relative-prediction-amplitude-error";
    public static final String CMD_ABS_PREDICTION_TIME_ERROR = "absolute-prediction-time-error";
    public static final String CMD_ABS_PREDICTION_AMPLITUDE_ERROR = "absolute-prediction-amplitude-error";
    public static final String CMD_REQUEST_SERIES = "request-series";
    public static final String CMD_REQUEST = "request";
    public static final String CMD_LOOK_AHEAD = "look-ahead";
    public static final String CMD_ALGORITHM = "algorithm";
    public static final String CMD_ALGORITHM_PARAMETER = "algorithm-parameter";

    public ConfigurationReader(InputStream input) {
        try {
            this.input = new BufferedReader(new InputStreamReader(input, "UTF8"));
        }
        catch (UnsupportedEncodingException ueEx) {
            throw new RuntimeException(ueEx);
        }
    }

    public Configuration read() throws IOException, ConfigurationException {
        String line;
        Long seed = null;
        Long totalTicks = null;
        Distribution<Integer> byterate = null;
        Distribution<Long> slotLength = null;
        Double networkUptime = null;
        Distribution<Double> relativeJitter = null;
        Distribution<Integer> absoluteJitter = null;
        Distribution<Double> relativePredictionTimeError = null;
        Distribution<Double> relativePredictionAmplitudeError = null;
        Distribution<Long> absolutePredictionTimeError = null;
        Distribution<Integer> absolutePredictionAmplitudeError = null;
        LinkedList<RequestSeries> recurringRequestSeries = new LinkedList<RequestSeries>();
        LinkedList<Request> intermittentRequests = new LinkedList<Request>();
        Long lookAheadTime = null;
        Class algorithm = NullAlgorithm.class;
        HashMap<String, String> algorithmConfiguration = new HashMap<String, String>();
        int lineCounter = 0;
        while ((line = this.input.readLine()) != null) {
            String command;
            ++lineCounter;
            String[] split = (line = line.replaceAll("#.*$", "")).split("\\s+");
            if (split.length == 0) continue;
            ArrayReader reader = new ArrayReader(split);
            while ((command = reader.next()) != null && command.length() == 0) {
            }
            if (command == null) continue;
            if (command.equals(CMD_SEED)) {
                seed = this.parseLong(lineCounter, CMD_SEED, reader);
                continue;
            }
            if (command.equals(CMD_TOTAL_TICKS)) {
                totalTicks = this.parseLong(lineCounter, CMD_TOTAL_TICKS, reader);
                continue;
            }
            if (command.equals(CMD_BYTERATE)) {
                byterate = this.parseDistribution(lineCounter, null, reader, Integer.class);
                continue;
            }
            if (command.equals(CMD_SLOT_LENGTH)) {
                slotLength = this.parseDistribution(lineCounter, null, reader, Long.class);
                continue;
            }
            if (command.equals(CMD_NETWORK_UPTIME)) {
                networkUptime = this.parseDouble(lineCounter, CMD_NETWORK_UPTIME, reader);
                continue;
            }
            if (command.equals(CMD_RELATIVE_JITTER)) {
                relativeJitter = this.parseDistribution(lineCounter, null, reader, Double.class);
                continue;
            }
            if (command.equals(CMD_ABSOLUTE_JITTER)) {
                absoluteJitter = this.parseDistribution(lineCounter, null, reader, Integer.class);
                continue;
            }
            if (command.equals(CMD_REL_PREDICTION_TIME_ERROR)) {
                relativePredictionTimeError = this.parseDistribution(lineCounter, null, reader, Double.class);
                continue;
            }
            if (command.equals(CMD_REL_PREDICTION_AMPLITUDE_ERROR)) {
                relativePredictionAmplitudeError = this.parseDistribution(lineCounter, null, reader, Double.class);
                continue;
            }
            if (command.equals(CMD_ABS_PREDICTION_TIME_ERROR)) {
                absolutePredictionTimeError = this.parseDistribution(lineCounter, null, reader, Long.class);
                continue;
            }
            if (command.equals(CMD_ABS_PREDICTION_AMPLITUDE_ERROR)) {
                absolutePredictionAmplitudeError = this.parseDistribution(lineCounter, null, reader, Integer.class);
                continue;
            }
            if (command.equals(CMD_REQUEST_SERIES)) {
                recurringRequestSeries.add(this.parseSeries(lineCounter, reader));
                continue;
            }
            if (command.equals(CMD_REQUEST)) {
                intermittentRequests.add(this.parseRequest(lineCounter, reader));
                continue;
            }
            if (command.equals(CMD_LOOK_AHEAD)) {
                lookAheadTime = this.parseLong(lineCounter, CMD_LOOK_AHEAD, reader);
                continue;
            }
            if (command.equals(CMD_ALGORITHM)) {
                algorithm = this.parseAlgorithm(lineCounter, reader);
                continue;
            }
            if (command.equals(CMD_ALGORITHM_PARAMETER)) {
                this.parseAlgorithmParameter(lineCounter, reader, algorithmConfiguration);
                continue;
            }
            throw new ConfigurationException("unknown command: " + command);
        }
        this.require(totalTicks, "total ticks");
        this.require(byterate, CMD_BYTERATE);
        this.require(slotLength, "slot length");
        this.require(networkUptime, "network uptime");
        this.require(relativeJitter, "relative jitter");
        this.require(absoluteJitter, "absolute jitter");
        this.require(relativePredictionTimeError, "relative prediction time error");
        this.require(relativePredictionAmplitudeError, "relative prediction amplitude error");
        this.require(absolutePredictionTimeError, "absolute prediction time error");
        this.require(absolutePredictionAmplitudeError, "absolute prediction amplitude error");
        this.require(lookAheadTime, "look ahead time");
        Configuration configuration = new Configuration(totalTicks, byterate, slotLength, networkUptime, relativeJitter, absoluteJitter, relativePredictionTimeError, relativePredictionAmplitudeError, absolutePredictionTimeError, absolutePredictionAmplitudeError, recurringRequestSeries, intermittentRequests, algorithm, algorithmConfiguration, lookAheadTime);
        if (seed != null) {
            configuration.setSeed(seed);
        }
        return configuration;
    }

    private void parseAlgorithmParameter(int lineCounter, ArrayReader reader, Map<String, String> algorithmConfiguration) throws ConfigurationException {
        this.assertLeft(reader, 2, CMD_ALGORITHM_PARAMETER);
        String k = reader.next();
        String v = reader.next();
        algorithmConfiguration.put(k, v);
    }

    private Request parseRequest(int lineCounter, ArrayReader reader) throws ConfigurationException {
        Long tick = this.parseLongParam(lineCounter, "tick", reader);
        Integer byterate = this.parseIntParam(lineCounter, CMD_BYTERATE, reader);
        Integer data = this.parseIntParam(lineCounter, "data", reader);
        return new Request(tick, data, byterate);
    }

    private RequestSeries parseSeries(int lineCounter, ArrayReader reader) throws ConfigurationException {
        Distribution<Long> interval = this.parseDistribution(lineCounter, "interval", reader, Long.class);
        Distribution<Integer> size = this.parseDistribution(lineCounter, "size", reader, Integer.class);
        Distribution<Integer> byterate = this.parseDistribution(lineCounter, CMD_BYTERATE, reader, Integer.class);
        Distribution<Long> startTick = this.parseDistribution(lineCounter, "start", reader, Long.class);
        Distribution<Long> endTick = this.parseDistribution(lineCounter, "end", reader, Long.class);
        return new RequestSeries(interval, size, byterate, startTick, endTick);
    }

    private <T extends Number> Distribution<T> parseDistribution(int lineCounter, String param, ArrayReader reader, Class<T> clazz) throws ConfigurationException {
        String value = null;
        value = this.getParam(lineCounter, param, reader);
        if (value == null || value.length() == 0) {
            throw new ConfigurationException("empty paramter for " + param + " on line " + lineCounter);
        }
        String[] split = value.split("\\/");
        if (split.length == 0) {
            throw new ConfigurationException("empty paramter for " + param + " on line " + lineCounter);
        }
        ArrayReader sub = new ArrayReader(split);
        String type = sub.next();
        if (this.isExact(type) && this.assertLeft(sub, 1, "exact")) {
            return Distributions.exact(this.parse(lineCounter, "exact", sub.next(), clazz));
        }
        if (this.isUniform(type) && this.assertLeft(sub, 2, "uniform")) {
            return Distributions.uniform(this.parse(lineCounter, "uniform min", sub.next(), clazz), this.parse(lineCounter, "uniform max", sub.next(), clazz), clazz);
        }
        if (this.isNormal(type) && this.assertLeft(sub, 2, "normal")) {
            return Distributions.normal(this.parse(lineCounter, "normal mean", sub.next(), clazz), this.parse(lineCounter, "normal sd", sub.next(), clazz), clazz);
        }
        return Distributions.exact(this.parse(lineCounter, "implicit exact", type, clazz));
    }

    private boolean isExact(String type) {
        return "exact".equals(type) || "exactly".equals(type) || "ex".equals(type) || "=".equals(type);
    }

    private boolean isUniform(String type) {
        return "uniform".equals(type) || "unif".equals(type) || "u".equals(type);
    }

    private boolean isNormal(String type) {
        return "normal".equals(type) || "norm".equals(type) || "n".equals(type) || "gaussian".equals(type) || "gauss".equals(type) || "g".equals(type) || "~".equals(type);
    }

    private <T extends Number> T parse(int lineCounter, String command, String param, Class<T> clazz) throws ConfigurationException {
        if (clazz.equals(Long.class)) {
            return (T)new Long(this.parseLong(lineCounter, command, param));
        }
        if (clazz.equals(Integer.class)) {
            return (T)new Integer(this.parseInt(lineCounter, command, param));
        }
        if (clazz.equals(Double.class)) {
            return (T)new Double(this.parseDouble(lineCounter, command, param));
        }
        throw new RuntimeException("unknown parse class " + clazz);
    }

    private long parseLong(int lineCounter, String command, String param) throws ConfigurationException {
        try {
            return Long.parseLong(param);
        }
        catch (NumberFormatException nfEx) {
            throw new ConfigurationException("could not parse parameter for " + command + " on line " + lineCounter + ": " + param, nfEx);
        }
    }

    private int parseInt(int lineCounter, String command, String param) throws ConfigurationException {
        try {
            return Integer.parseInt(param);
        }
        catch (NumberFormatException nfEx) {
            throw new ConfigurationException("could not parse parameter for " + command + " on line " + lineCounter + ": " + param, nfEx);
        }
    }

    private double parseDouble(int lineCounter, String command, String param) throws ConfigurationException {
        try {
            return Double.parseDouble(param);
        }
        catch (NumberFormatException nfEx) {
            throw new ConfigurationException("could not parse parameter for " + command + " on line " + lineCounter + ": " + param, nfEx);
        }
    }

    private boolean assertLeft(ArrayReader reader, int count, String parameter) throws ConfigurationException {
        if (reader.getRemaining() != count) {
            throw new ConfigurationException("expected " + count + " parameters for " + parameter + ", got " + reader.getRemaining());
        }
        return true;
    }

    private long parseLongParam(int lineCounter, String param, ArrayReader reader) throws ConfigurationException {
        return this.parseLong(lineCounter, param, this.getParam(lineCounter, param, reader));
    }

    private int parseIntParam(int lineCounter, String param, ArrayReader reader) throws ConfigurationException {
        return this.parseInt(lineCounter, param, this.getParam(lineCounter, param, reader));
    }

    private String getParam(int lineCouter, String param, ArrayReader reader) throws ConfigurationException {
        String key;
        if (param == null) {
            return reader.next();
        }
        ArrayReader clone = new ArrayReader(reader);
        while ((key = clone.next()) != null) {
            if (!param.equals(key)) continue;
            return clone.next();
        }
        throw new ConfigurationException("line" + lineCouter + ": parameter " + param + " not found");
    }

    private Double parseDouble(int lineCounter, String command, ArrayReader reader) throws ConfigurationException {
        String param = reader.next();
        if (param == null) {
            throw new ConfigurationException("line " + lineCounter + ": usage is \"" + command + " <parameter>");
        }
        return this.parseDouble(lineCounter, command, param);
    }

    private Long parseLong(int lineCounter, String command, ArrayReader reader) throws ConfigurationException {
        String param = reader.next();
        if (param == null) {
            throw new ConfigurationException("line " + lineCounter + ": usage is \"" + command + " <parameter>");
        }
        return this.parseLong(lineCounter, command, param);
    }

    private void require(Object parameter, String name) throws ConfigurationException {
        if (parameter == null) {
            throw new ConfigurationException("required parameter missing: " + name);
        }
    }

    private Class<? extends PrefetchAlgorithm> parseAlgorithm(int lineCounter, ArrayReader reader) throws ConfigurationException {
        String param = reader.next();
        if (param == null) {
            throw new ConfigurationException("line " + lineCounter + ": usage is \"" + CMD_ALGORITHM + " <algorithm-class>");
        }
        try {
            Class<?> clazz = Class.forName(param);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("line " + lineCounter + ": class not found: " + param, e);
        }
    }

    private class ArrayReader {
        private final String[] array;
        private int next = 0;

        public ArrayReader(String[] array) {
            this.array = array;
        }

        public int getRemaining() {
            return this.array.length - this.next;
        }

        public ArrayReader(ArrayReader that) {
            this.array = that.array;
            this.next = that.next;
        }

        public String next() {
            if (this.next >= this.array.length) {
                return null;
            }
            return this.array[this.next++];
        }
    }
}

