/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.prefetchsimulation.members.server;

import at.borkowski.prefetchsimulation.internal.VirtualPayload;
import at.borkowski.prefetchsimulation.members.server.FetchServer;
import at.borkowski.scovillej.services.comm.SimulationSocket;
import at.borkowski.scovillej.simulation.SimulationContext;
import java.io.IOException;

public class ClientProcessor {
    private final FetchServer owner;
    private final SimulationSocket<VirtualPayload> socket;

    public ClientProcessor(FetchServer owner, SimulationSocket<VirtualPayload> socket) {
        this.owner = owner;
        this.socket = socket;
    }

    public void handle(SimulationContext context) throws IOException {
        if (this.socket.available() == 0) {
            return;
        }
        VirtualPayload request = (VirtualPayload)this.socket.read();
        if (request == null) {
            this.close();
        } else {
            this.handle(request, context);
        }
    }

    private void handle(VirtualPayload request, SimulationContext context) throws IOException {
        this.socket.write((Object)new VirtualPayload(request.getSize()));
    }

    private void close() {
        this.socket.close();
        this.owner.deregisterClientProcessor(this);
    }
}

