/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.prefetchsimulation.members.client;

import at.borkowski.prefetchsimulation.Request;
import at.borkowski.prefetchsimulation.algorithms.NullAlgorithm;
import at.borkowski.prefetchsimulation.algorithms.PrefetchAlgorithm;
import at.borkowski.prefetchsimulation.internal.VirtualPayload;
import at.borkowski.prefetchsimulation.members.aux.RateControlService;
import at.borkowski.prefetchsimulation.members.aux.RatePredictionService;
import at.borkowski.prefetchsimulation.members.client.FetchClient;
import at.borkowski.scovillej.simulation.Simulation;
import at.borkowski.scovillej.simulation.SimulationContext;
import at.borkowski.scovillej.simulation.SimulationInitializationContext;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FetchProcessor {
    private final FetchClient owner;
    private RateControlService rateControlService;
    private RatePredictionService ratePredictionService;
    private final Set<Request> toFetch = new HashSet<Request>();
    private Map<Request, Long> scheduled = new HashMap<Request, Long>();
    private PrefetchAlgorithm algorithm = new NullAlgorithm();
    private long lookAheadTime = Long.MAX_VALUE;
    private Request current = null;
    private long currentRequested = -1L;

    public FetchProcessor(FetchClient owner) {
        this.owner = owner;
    }

    public void executePhase(SimulationContext context) throws IOException {
        long tick = context.getCurrentTick();
        if (this.current != null) {
            VirtualPayload payload = this.owner.getSocketProcessor().readIfPossible();
            if (payload != null) {
                this.owner.getProfilingService().response(this.current);
                this.rateControlService.setRequestSpecificRate(null);
                this.owner.getCacheProcessor().save(this.current, tick, this.currentRequested);
                this.toFetch.remove(this.current);
                this.scheduled.remove(this.current);
                this.current = null;
            }
        } else {
            this.current = null;
            for (Request request : this.scheduled.keySet()) {
                if (this.scheduled.get(request) > tick || this.current != null && this.scheduled.get(request) >= this.scheduled.get(this.current)) continue;
                this.current = request;
            }
            this.scheduled.remove(this.current);
            if (this.current != null) {
                this.currentRequested = tick;
                this.owner.getProfilingService().request(this.current);
                this.owner.getSocketProcessor().request(this.current);
                this.rateControlService.setRequestSpecificRate(this.current.getAvailableByterate());
            }
        }
        this.reschedule(tick, false);
    }

    private void reschedule(long tick, boolean force) {
        HashSet<Request> current = new HashSet<Request>();
        for (Request request : this.toFetch) {
            if (request.getDeadline() - tick > this.lookAheadTime) continue;
            current.add(request);
        }
        boolean newRequest = force;
        if (!force) {
            for (Request req : current) {
                newRequest |= !this.scheduled.containsKey(req);
            }
        }
        if (newRequest) {
            Map<Request, Long> map = this.algorithm.schedule(current, this.ratePredictionService);
            this.scheduled.putAll(map);
            if (this.owner.getProfilingService() != null) {
                for (Request req : this.scheduled.keySet()) {
                    this.owner.getProfilingService().scheduled(req, this.scheduled.get(req));
                }
            }
        }
    }

    public void initialize(Simulation simulation, SimulationInitializationContext context) {
        this.rateControlService = (RateControlService)context.getService(RateControlService.class);
        this.ratePredictionService = (RatePredictionService)context.getService(RatePredictionService.class);
        this.reschedule(0L, true);
    }

    public void addRequests(Collection<Request> requests) {
        this.toFetch.addAll(requests);
    }

    public void setAlgorithm(PrefetchAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    public void urge(long tick, Request request) {
        this.scheduled.put(request, tick);
    }

    public PrefetchAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public Set<Request> getPendingRequests() {
        return this.toFetch;
    }

    public long getLookAheadTime() {
        return this.lookAheadTime;
    }

    public void setLookAheadTime(long lookAheadTime) {
        this.lookAheadTime = lookAheadTime;
    }
}

