/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.prefetchsimulation.configuration.distributions;

import at.borkowski.prefetchsimulation.configuration.distributions.Distribution;
import at.borkowski.prefetchsimulation.util.RandomSource;

public class UniformDoubleDistribution
implements Distribution<Double> {
    private final double min;
    private final double max;

    public UniformDoubleDistribution(double min, double max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public Double getValue(RandomSource randomSource) {
        if (this.min == this.max) {
            return this.min;
        }
        double r = randomSource.nextDouble() * (this.max - this.min);
        return this.min + r;
    }

    @Override
    public Double getMean() {
        return this.min + (this.max - this.min) / 2.0;
    }
}

