/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.prefetchsimulation.configuration.distributions;

import at.borkowski.prefetchsimulation.configuration.distributions.Distribution;
import at.borkowski.prefetchsimulation.util.RandomSource;

public class NormalLongDistribution
implements Distribution<Long> {
    private final long mean;
    private final long sd;

    public NormalLongDistribution(long mean, long sd) {
        this.mean = mean;
        this.sd = sd;
    }

    @Override
    public Long getValue(RandomSource randomSource) {
        if (this.sd == 0L) {
            return this.mean;
        }
        return (long)(randomSource.nextGaussian() * (double)this.sd + (double)this.mean);
    }

    @Override
    public Long getMean() {
        return this.mean;
    }
}

