/*
 * Decompiled with CFR 0.152.
 */
package at.bestsolution.fx.test.rcontrol.impl;

import at.bestsolution.fx.test.rcontrol.Click;
import at.bestsolution.fx.test.rcontrol.Drag;
import at.bestsolution.fx.test.rcontrol.Move;
import at.bestsolution.fx.test.rcontrol.RController;
import at.bestsolution.fx.test.rcontrol.RNode;
import at.bestsolution.fx.test.rcontrol.Type;
import java.time.Duration;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.input.MouseButton;

public class RNodeImpl<T extends Node>
implements RNode<T> {
    private final T node;
    private final RController controller;

    public RNodeImpl(T node, RController controller) {
        this.node = node;
        this.controller = controller;
    }

    @Override
    public T node() {
        return this.node;
    }

    @Override
    public RNode<T> focus() {
        this.node.requestFocus();
        return this;
    }

    private RNode<T> _click(MouseButton button) {
        this.moveToCenter();
        this.controller.run(Click.click(button));
        return this;
    }

    private RNode<T> _click(MouseButton button, double x, double y) {
        this.controller.run(Click.click(button, x, y));
        return this;
    }

    @Override
    public RNode<T> click() {
        return this._click(MouseButton.PRIMARY);
    }

    @Override
    public RNode<T> click(MouseButton button) {
        return this._click(button);
    }

    @Override
    public RNode<T> click(double x, double y) {
        return this._click(MouseButton.PRIMARY, x, y);
    }

    @Override
    public RNode<T> click(MouseButton button, double x, double y) {
        return this._click(button, x, y);
    }

    @Override
    public RNode<T> doubleClick() {
        return this.doubleClick(MouseButton.PRIMARY);
    }

    @Override
    public RNode<T> doubleClick(MouseButton button) {
        this._click(button);
        this._click(button);
        return this;
    }

    @Override
    public RNode<T> doubleClick(double x, double y) {
        return this.doubleClick(MouseButton.PRIMARY, x, y);
    }

    @Override
    public RNode<T> doubleClick(MouseButton button, double x, double y) {
        this._click(button, x, y);
        this._click(button, x, y);
        return this;
    }

    @Override
    public RNode<T> moveToCenter() {
        Bounds bounds = this.node.getBoundsInLocal();
        this.moveTo(bounds.getWidth() / 2.0, bounds.getHeight() / 2.0);
        return this;
    }

    @Override
    public RNode<T> moveTo(double x, double y) {
        Bounds bounds = this.node.localToScreen(this.node.getBoundsInLocal());
        this.controller.run(Move.to(bounds.getMinX() + x, bounds.getMinY() + y));
        return this;
    }

    @Override
    public RNode<T> moveToCenter(Duration d) {
        Bounds bounds = this.node.getBoundsInLocal();
        return this.moveTo(d, bounds.getWidth() / 2.0, bounds.getHeight() / 2.0);
    }

    @Override
    public RNode<T> moveTo(Duration d, double x, double y) {
        Bounds bounds = this.node.localToScreen(this.node.getBoundsInLocal());
        this.controller.run(Move.to(d, bounds.getMinX() + x, bounds.getMinY() + y));
        return null;
    }

    @Override
    public RNode<T> moveTo(Duration d, Pos referencePoint, double _x, double _y) {
        double y;
        double x;
        Bounds bounds = this.node.localToScreen(this.node.getBoundsInLocal());
        switch (referencePoint.getHpos()) {
            case CENTER: {
                x = bounds.getMinX() + bounds.getWidth() / 2.0;
                break;
            }
            case RIGHT: {
                x = bounds.getMaxX();
                break;
            }
            default: {
                x = bounds.getMinX();
            }
        }
        switch (referencePoint.getVpos()) {
            case BOTTOM: 
            case BASELINE: {
                y = bounds.getMaxY();
                break;
            }
            case CENTER: {
                y = bounds.getMinY() + bounds.getHeight() / 2.0;
                break;
            }
            default: {
                y = bounds.getMinY();
            }
        }
        this.controller.run(Move.to(d, x + _x, y + _y));
        return this;
    }

    @Override
    public RNode<T> moveTo(Pos referencePoint, double _x, double _y) {
        double y;
        double x;
        Bounds bounds = this.node.localToScreen(this.node.getBoundsInLocal());
        switch (referencePoint.getHpos()) {
            case CENTER: {
                x = bounds.getMinX() + bounds.getWidth() / 2.0;
                break;
            }
            case RIGHT: {
                x = bounds.getMaxX();
                break;
            }
            default: {
                x = bounds.getMinX();
            }
        }
        switch (referencePoint.getVpos()) {
            case BOTTOM: 
            case BASELINE: {
                y = bounds.getMaxY();
                break;
            }
            case CENTER: {
                y = bounds.getMinY() + bounds.getHeight() / 2.0;
                break;
            }
            default: {
                y = bounds.getMinY();
            }
        }
        this.controller.run(Move.to(x + _x, y + _y));
        return this;
    }

    @Override
    public RNode<T> dragTo(double x, double y) {
        Bounds bounds = this.node.localToScreen(this.node.getBoundsInLocal());
        this.controller.run(Drag.to(bounds.getWidth() / 2.0, bounds.getHeight() / 2.0, x, y));
        return this;
    }

    @Override
    public RNode<T> dragTo(Duration d, double x, double y) {
        Bounds bounds = this.node.localToScreen(this.node.getBoundsInLocal());
        this.controller.run(Drag.to(d, bounds.getWidth() / 2.0, bounds.getHeight() / 2.0, x, y));
        return this;
    }

    @Override
    public RNode<T> dragBy(double dx, double dy) {
        Bounds bounds = this.node.localToScreen(this.node.getBoundsInLocal());
        this.controller.run(Drag.by(bounds.getMinX() + bounds.getWidth() / 2.0, bounds.getMinY() + bounds.getHeight() / 2.0, dx, dy));
        return this;
    }

    @Override
    public RNode<T> dragBy(Duration d, double dx, double dy) {
        Bounds bounds = this.node.localToScreen(this.node.getBoundsInLocal());
        this.controller.run(Drag.by(d, bounds.getMinX() + bounds.getWidth() / 2.0, bounds.getMinY() + bounds.getHeight() / 2.0, dx, dy));
        return this;
    }

    @Override
    public RNode<T> typeText(String text) {
        this.focus();
        this.controller.run(Type.text(text));
        return this;
    }

    @Override
    public Point2D center() {
        Bounds bounds = this.node.localToScreen(this.node.getBoundsInLocal());
        return new Point2D(bounds.getMinX() + bounds.getWidth() / 2.0, bounds.getMinY() + bounds.getHeight() / 2.0);
    }

    @Override
    public Point2D location(Pos position) {
        double y;
        double x;
        Bounds bounds = this.node.localToScreen(this.node.getBoundsInLocal());
        switch (position.getHpos()) {
            case CENTER: {
                x = bounds.getMinX() + bounds.getWidth() / 2.0;
                break;
            }
            case RIGHT: {
                x = bounds.getMaxX();
                break;
            }
            default: {
                x = bounds.getMinX();
            }
        }
        switch (position.getVpos()) {
            case BOTTOM: 
            case BASELINE: {
                y = bounds.getMaxY();
                break;
            }
            case CENTER: {
                y = bounds.getMinY() + bounds.getHeight() / 2.0;
                break;
            }
            default: {
                y = bounds.getMinY();
            }
        }
        return new Point2D(x, y);
    }
}

