/*
 * Decompiled with CFR 0.152.
 */
package at.bestsolution.fx.test.rcontrol.impl;

import at.bestsolution.fx.test.rcontrol.Operation;
import at.bestsolution.fx.test.rcontrol.RController;
import at.bestsolution.fx.test.rcontrol.RNode;
import at.bestsolution.fx.test.rcontrol.RRobot;
import at.bestsolution.fx.test.rcontrol.impl.RNodeImpl;
import com.sun.glass.ui.Application;
import com.sun.glass.ui.Robot;
import com.sun.javafx.robot.FXRobot;
import com.sun.javafx.robot.FXRobotFactory;
import java.time.Duration;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.MouseButton;
import org.eclipse.fx.core.ServiceUtils;
import org.eclipse.fx.core.ThreadSynchronize;
import org.eclipse.fx.ui.controls.JavaFXCompatUtil;

public class FXRobotRemoteController
implements RController,
RRobot {
    private final Scene scene;
    private final Robot glassRobot;
    private final FXRobot fxRobot;
    private final ThreadSynchronize threadSynchronize;

    public FXRobotRemoteController(Scene scene) {
        this.scene = scene;
        this.glassRobot = Application.GetApplication().createRobot();
        this.fxRobot = FXRobotFactory.createRobot((Scene)scene);
        this.threadSynchronize = ServiceUtils.getService(ThreadSynchronize.class).orElse(null);
    }

    public FXRobotRemoteController(FXRobotRemoteController r) {
        this.scene = r.scene;
        this.glassRobot = r.glassRobot;
        this.fxRobot = r.fxRobot;
        this.threadSynchronize = r.threadSynchronize;
    }

    @Override
    public RRobot eventGenerator() {
        return this;
    }

    @Override
    public final int mouseX() {
        return this.glassRobot.getMouseX();
    }

    @Override
    public final int mouseY() {
        return this.glassRobot.getMouseY();
    }

    @Override
    public final RController mouseMoveTo(int x, int y) {
        this.glassRobot.mouseMove(x, y);
        return this;
    }

    @Override
    public final RController press(MouseButton button) {
        this.glassRobot.mousePress(button.ordinal());
        return this;
    }

    @Override
    public final RController release(MouseButton button) {
        this.glassRobot.mouseRelease(button.ordinal());
        return this;
    }

    @Override
    public final RController block(ThreadSynchronize.BlockCondition<Void> b) {
        this.threadSynchronize.block(b);
        return this;
    }

    @Override
    public RController run(Operation ... ops) {
        for (Operation op : ops) {
            op.execute(this);
        }
        this.sleep(100L);
        return this;
    }

    @Override
    public RController waitForRender() {
        this.sleep(2000L);
        return this;
    }

    @Override
    public <T extends Node> Stream<RNode<T>> css(String selector) {
        if (this.scene.getRoot() != null) {
            return this.scene.getRoot().lookupAll(selector).stream().map(v -> new RNodeImpl<Node>((Node)v, this));
        }
        return Stream.empty();
    }

    @Override
    public <T extends Node> Stream<RNode<T>> css(Class<T> type, String selector) {
        return this.css(selector).filter(r -> type.isAssignableFrom(r.node().getClass()));
    }

    @Override
    public <T extends Node> Optional<RNode<T>> cssFirst(String selector) {
        return this.css(selector).findFirst();
    }

    @Override
    public <T extends Node> Optional<RNode<T>> cssFirst(Class<T> type, String selector) {
        return this.css(type, selector).findFirst();
    }

    @Override
    public RController type(KeyCode ... codes) {
        for (KeyCode code : codes) {
            int c = JavaFXCompatUtil.getCode((KeyCode)code);
            this.glassRobot.keyPress(c);
            this.glassRobot.keyRelease(c);
        }
        return this;
    }

    @Override
    public RController type(KeyCodeCombination ... combinations) {
        for (KeyCodeCombination combination : combinations) {
            if (combination.getAlt() == KeyCombination.ModifierValue.DOWN) {
                this.glassRobot.keyPress(JavaFXCompatUtil.getCode((KeyCode)KeyCode.ALT));
            }
            if (combination.getShift() == KeyCombination.ModifierValue.DOWN) {
                this.glassRobot.keyPress(JavaFXCompatUtil.getCode((KeyCode)KeyCode.SHIFT));
            }
            if (combination.getControl() == KeyCombination.ModifierValue.DOWN) {
                this.glassRobot.keyPress(JavaFXCompatUtil.getCode((KeyCode)KeyCode.CONTROL));
            }
            this.glassRobot.keyPress(JavaFXCompatUtil.getCode((KeyCode)combination.getCode()));
            this.glassRobot.keyRelease(JavaFXCompatUtil.getCode((KeyCode)combination.getCode()));
            if (combination.getAlt() == KeyCombination.ModifierValue.DOWN) {
                this.glassRobot.keyRelease(JavaFXCompatUtil.getCode((KeyCode)KeyCode.ALT));
            }
            if (combination.getShift() == KeyCombination.ModifierValue.DOWN) {
                this.glassRobot.keyRelease(JavaFXCompatUtil.getCode((KeyCode)KeyCode.SHIFT));
            }
            if (combination.getControl() != KeyCombination.ModifierValue.DOWN) continue;
            this.glassRobot.keyRelease(JavaFXCompatUtil.getCode((KeyCode)KeyCode.CONTROL));
        }
        return this;
    }

    @Override
    public RController text(String text) {
        for (int i = 0; i < text.length(); ++i) {
            this.fxRobot.keyType(KeyCode.UNDEFINED, text.substring(i, i + 1));
        }
        return this;
    }

    @Override
    public RController sleep(Duration duration) {
        this.sleep(duration.toMillis());
        return this;
    }

    @Override
    public RController run(Consumer<RController> c) {
        c.accept(this);
        return this;
    }

    @Override
    public <R> R run(Function<RController, R> f) {
        return f.apply(this);
    }

    @Override
    public RController run(Runnable r) {
        r.run();
        return this;
    }

    @Override
    public final RController sleep(long millis) {
        ThreadSynchronize.BlockCondition b = new ThreadSynchronize.BlockCondition();
        this.threadSynchronize.scheduleExecution(millis, () -> b.release(null));
        this.threadSynchronize.block(b);
        return this;
    }
}

