/*
 * Decompiled with CFR 0.152.
 */
package at.bestsolution.fx.test.rcontrol;

import at.bestsolution.fx.test.rcontrol.Operation;
import javafx.animation.Transition;
import javafx.scene.input.MouseButton;
import javafx.util.Duration;
import org.eclipse.fx.core.ThreadSynchronize;

public interface Drag {
    public static Operation to(double fromX, double fromY, double toX, double toY) {
        return r -> {
            r.mouseMoveTo((int)fromX, (int)fromY);
            r.press(MouseButton.PRIMARY);
            r.mouseMoveTo((int)toX, (int)toY);
            r.release(MouseButton.PRIMARY);
            return r;
        };
    }

    public static Operation to(final java.time.Duration d, final double fromX, final double fromY, double toX, double toY) {
        return r -> {
            r.mouseMoveTo((int)fromX, (int)fromY);
            ThreadSynchronize.BlockCondition b = new ThreadSynchronize.BlockCondition();
            final double dx = toX - fromX;
            final double dy = toY - fromY;
            Transition tt = new Transition(){
                {
                    this.setCycleDuration(Duration.millis((double)d.toMillis()));
                }

                protected void interpolate(double frac) {
                    r.mouseMoveTo((int)(fromX + dx * frac), (int)(fromY + dy * frac));
                }
            };
            tt.setOnFinished(e -> b.release(null));
            tt.play();
            r.block((ThreadSynchronize.BlockCondition<Void>)b);
            return r;
        };
    }

    public static Operation by(double fromX, double fromY, double dx, double dy) {
        return r -> {
            r.mouseMoveTo((int)fromX, (int)fromY);
            r.press(MouseButton.PRIMARY);
            r.mouseMoveTo((int)(fromX + dx), (int)(fromY + dy));
            r.release(MouseButton.PRIMARY);
            return r;
        };
    }

    public static Operation by(final java.time.Duration d, final double fromX, final double fromY, final double dx, final double dy) {
        return r -> {
            r.mouseMoveTo((int)fromX, (int)fromY);
            r.press(MouseButton.PRIMARY);
            ThreadSynchronize.BlockCondition b = new ThreadSynchronize.BlockCondition();
            Transition tt = new Transition(){
                {
                    this.setCycleDuration(Duration.millis((double)d.toMillis()));
                }

                protected void interpolate(double frac) {
                    r.mouseMoveTo((int)(fromX + dx * frac), (int)(fromY + dy * frac));
                }
            };
            tt.setOnFinished(e -> b.release(null));
            tt.play();
            r.block((ThreadSynchronize.BlockCondition<Void>)b);
            r.release(MouseButton.PRIMARY);
            return r;
        };
    }

    public static interface Dragable<C> {
        public C dragTo(double var1, double var3);

        public C dragTo(java.time.Duration var1, double var2, double var4);

        public C dragBy(double var1, double var3);

        public C dragBy(java.time.Duration var1, double var2, double var4);
    }
}

