/*
 * Decompiled with CFR 0.152.
 */
package at.austriapro.ebinterface.xrechnung.validator;

import com.helger.bdve.en16931.EN16931Validation;
import com.helger.bdve.execute.ValidationExecutionManager;
import com.helger.bdve.executorset.IValidationExecutorSet;
import com.helger.bdve.executorset.VESID;
import com.helger.bdve.executorset.ValidationExecutorSetRegistry;
import com.helger.bdve.result.ValidationResultList;
import com.helger.bdve.source.IValidationSource;
import com.helger.bdve.source.ValidationSource;
import com.helger.bdve.xrechnung.XRechnungValidation;
import com.helger.commons.error.list.ErrorList;
import javax.annotation.Nonnull;
import org.w3c.dom.Node;

public final class XRechnungValidator {
    private static final ValidationExecutorSetRegistry VES_REGISTRY = new ValidationExecutorSetRegistry();

    private XRechnungValidator() {
    }

    private static void _validateXRechnung(@Nonnull VESID vESID, @Nonnull Node node, @Nonnull ErrorList errorList) {
        IValidationExecutorSet iValidationExecutorSet = VES_REGISTRY.getOfID(vESID);
        if (iValidationExecutorSet == null) {
            throw new IllegalStateException("Failed to resolve VESID " + vESID);
        }
        ValidationExecutionManager validationExecutionManager = iValidationExecutorSet.createExecutionManager();
        ValidationSource validationSource = ValidationSource.create(null, (Node)node);
        ValidationResultList validationResultList = validationExecutionManager.executeValidation((IValidationSource)validationSource);
        validationResultList.forEachFlattened(arg_0 -> errorList.add(arg_0));
    }

    public static void validateXRechnungCII(@Nonnull Node node, @Nonnull ErrorList errorList) {
        XRechnungValidator._validateXRechnung(XRechnungValidation.VID_XRECHNUNG_CII_122, node, errorList);
    }

    public static void validateXRechnungUBLInvoice(@Nonnull Node node, @Nonnull ErrorList errorList) {
        XRechnungValidator._validateXRechnung(XRechnungValidation.VID_XRECHNUNG_UBL_INVOICE_122, node, errorList);
    }

    public static void validateXRechnungUBLCreditNote(@Nonnull Node node, @Nonnull ErrorList errorList) {
        XRechnungValidator._validateXRechnung(XRechnungValidation.VID_XRECHNUNG_UBL_CREDITNOTE_122, node, errorList);
    }

    static {
        EN16931Validation.initEN16931((ValidationExecutorSetRegistry)VES_REGISTRY);
        XRechnungValidation.initXRechnung((ValidationExecutorSetRegistry)VES_REGISTRY);
    }
}

