/*
 * Decompiled with CFR 0.152.
 */
package at.austriapro.ebinterface.xrechnung.to.ubl;

import at.austriapro.ebinterface.ubl.to.EbInterface50ToInvoiceConverter;
import at.austriapro.ebinterface.xrechnung.to.ubl.AbstractEbInterfaceToXRechnungUBLConverter;
import at.austriapro.ebinterface.xrechnung.validator.XRechnungValidator;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.error.list.IErrorList;
import com.helger.ebinterface.EEbInterfaceVersion;
import com.helger.ebinterface.v50.Ebi50InvoiceType;
import com.helger.jaxb.validation.WrappedCollectingValidationEventHandler;
import com.helger.ubl21.UBL21Writer;
import com.helger.ubl21.UBL21WriterBuilder;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.ValidationEventHandler;
import oasis.names.specification.ubl.schema.xsd.invoice_21.InvoiceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class EbInterface50ToXRechnungUBLConverter
extends AbstractEbInterfaceToXRechnungUBLConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(EbInterface50ToXRechnungUBLConverter.class);
    private static final EEbInterfaceVersion VERSION = EEbInterfaceVersion.V50;
    private static final String VERSION_STR = "ebInterface " + VERSION.getVersion().getAsStringMajorMinor();

    public EbInterface50ToXRechnungUBLConverter(@Nonnull Locale locale, @Nonnull Locale locale2) {
        super(locale, locale2);
    }

    @Nullable
    public InvoiceType convert(@Nonnull Ebi50InvoiceType ebi50InvoiceType, @Nonnull ErrorList errorList) {
        InvoiceType invoiceType = new EbInterface50ToInvoiceConverter(this.m_aDisplayLocale, this.m_aContentLocale).convertInvoice(ebi50InvoiceType);
        assert (invoiceType != null);
        EbInterface50ToXRechnungUBLConverter.modifyDefaultUBLInvoice(invoiceType);
        int n = errorList.getErrorCount();
        int n2 = EbInterface50ToXRechnungUBLConverter.countWarnings((IErrorList)errorList);
        Document document = ((UBL21WriterBuilder)UBL21Writer.invoice().setValidationEventHandler((ValidationEventHandler)new WrappedCollectingValidationEventHandler(errorList))).getAsDocument((Object)invoiceType);
        if (document == null) {
            return null;
        }
        int n3 = errorList.getErrorCount();
        int n4 = EbInterface50ToXRechnungUBLConverter.countWarnings((IErrorList)errorList);
        if (n4 > n2) {
            LOGGER.warn("The conversion from " + VERSION_STR + " to UBL found " + EbInterface50ToXRechnungUBLConverter.warningText(n4 - n2));
        }
        if (n3 > n) {
            LOGGER.warn("The conversion from " + VERSION_STR + " to UBL found " + EbInterface50ToXRechnungUBLConverter.errorText(n3 - n));
            return null;
        }
        n = n3;
        n2 = n4;
        XRechnungValidator.validateXRechnungUBLInvoice(document, errorList);
        n3 = errorList.getErrorCount();
        n4 = EbInterface50ToXRechnungUBLConverter.countWarnings((IErrorList)errorList);
        if (n3 > n) {
            LOGGER.warn("The validation of the XRechnung found " + EbInterface50ToXRechnungUBLConverter.errorText(n3 - n));
        }
        return invoiceType;
    }
}

