/*
 * Decompiled with CFR 0.152.
 */
package at.austriapro.ebinterface.xrechnung.from.ubl;

import at.austriapro.ebinterface.ubl.from.IToEbinterfaceSettings;
import at.austriapro.ebinterface.ubl.from.invoice.ICustomInvoiceToEbInterface43Converter;
import at.austriapro.ebinterface.ubl.from.invoice.InvoiceToEbInterface43Converter;
import at.austriapro.ebinterface.xrechnung.from.ubl.AbstractXRechnungUBLToEbInterfaceConverter;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.error.list.IErrorList;
import com.helger.ebinterface.EEbInterfaceVersion;
import com.helger.ebinterface.v43.Ebi43InvoiceType;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import oasis.names.specification.ubl.schema.xsd.invoice_21.InvoiceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XRechnungUBLInvoiceToEbInterface43Converter
extends AbstractXRechnungUBLToEbInterfaceConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(XRechnungUBLInvoiceToEbInterface43Converter.class);
    private static final EEbInterfaceVersion VERSION = EEbInterfaceVersion.V43;
    private static final String VERSION_STR = "ebInterface " + VERSION.getVersion().getAsStringMajorMinor();
    private final ICustomInvoiceToEbInterface43Converter m_aCustomizer = null;

    public XRechnungUBLInvoiceToEbInterface43Converter(@Nonnull Locale locale, @Nonnull Locale locale2) {
        super(locale, locale2);
    }

    @Nullable
    public Ebi43InvoiceType convert(@Nonnull InvoiceType invoiceType, @Nonnull ErrorList errorList) {
        int n = errorList.getErrorCount();
        int n2 = XRechnungUBLInvoiceToEbInterface43Converter.countWarnings((IErrorList)errorList);
        Ebi43InvoiceType ebi43InvoiceType = new InvoiceToEbInterface43Converter(this.m_aDisplayLocale, this.m_aContentLocale, (IToEbinterfaceSettings)this.m_aToEbiSettings).setCustomizer(this.m_aCustomizer).convertToEbInterface(invoiceType, errorList);
        int n3 = errorList.getErrorCount();
        int n4 = XRechnungUBLInvoiceToEbInterface43Converter.countWarnings((IErrorList)errorList);
        if (n4 > n2) {
            LOGGER.warn("The conversion from UBL to " + VERSION_STR + " found " + XRechnungUBLInvoiceToEbInterface43Converter.warningText(n4 - n2));
        }
        if (n3 > n) {
            LOGGER.warn("The conversion from UBL to " + VERSION_STR + " found " + XRechnungUBLInvoiceToEbInterface43Converter.errorText(n3 - n));
            return null;
        }
        return ebi43InvoiceType;
    }
}

