/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.ariadne.routeformat.location;

import at.ac.ait.ariadne.routeformat.Validatable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Address
implements Validatable {
    private Optional<String> country = Optional.absent();
    private Optional<String> city = Optional.absent();
    private Optional<String> postCode = Optional.absent();
    private Optional<String> streetName = Optional.absent();
    private Optional<String> houseNumber = Optional.absent();
    private Map<String, Object> additionalInfo = new TreeMap<String, Object>();

    public Optional<String> getCountry() {
        return this.country;
    }

    public Optional<String> getCity() {
        return this.city;
    }

    public Optional<String> getPostCode() {
        return this.postCode;
    }

    public Optional<String> getStreetName() {
        return this.streetName;
    }

    public Optional<String> getHouseNumber() {
        return this.houseNumber;
    }

    public Map<String, Object> getAdditionalInfo() {
        return this.additionalInfo;
    }

    public Address setCountry(String country) {
        this.country = Optional.fromNullable((Object)country);
        return this;
    }

    public Address setCity(String city) {
        this.city = Optional.fromNullable((Object)city);
        return this;
    }

    public Address setPostCode(String postCode) {
        this.postCode = Optional.fromNullable((Object)postCode);
        return this;
    }

    public Address setStreetName(String streetName) {
        this.streetName = Optional.fromNullable((Object)streetName);
        return this;
    }

    public Address setHouseNumber(String houseNumber) {
        this.houseNumber = Optional.fromNullable((Object)houseNumber);
        return this;
    }

    public Address setAdditionalInfo(Map<String, Object> additionalInfo) {
        this.additionalInfo = new TreeMap<String, Object>(additionalInfo);
        return this;
    }

    public static Address create(String streetName, String houseNumber) {
        return new Address().setStreetName(streetName).setHouseNumber(houseNumber);
    }

    @Override
    public void validate() {
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.additionalInfo == null ? 0 : this.additionalInfo.hashCode());
        result = 31 * result + (this.city == null ? 0 : this.city.hashCode());
        result = 31 * result + (this.country == null ? 0 : this.country.hashCode());
        result = 31 * result + (this.houseNumber == null ? 0 : this.houseNumber.hashCode());
        result = 31 * result + (this.postCode == null ? 0 : this.postCode.hashCode());
        result = 31 * result + (this.streetName == null ? 0 : this.streetName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Address other = (Address)obj;
        if (this.additionalInfo == null ? other.additionalInfo != null : !this.additionalInfo.equals(other.additionalInfo)) {
            return false;
        }
        if (this.city == null ? other.city != null : !this.city.equals(other.city)) {
            return false;
        }
        if (this.country == null ? other.country != null : !this.country.equals(other.country)) {
            return false;
        }
        if (this.houseNumber == null ? other.houseNumber != null : !this.houseNumber.equals(other.houseNumber)) {
            return false;
        }
        if (this.postCode == null ? other.postCode != null : !this.postCode.equals(other.postCode)) {
            return false;
        }
        return !(this.streetName == null ? other.streetName != null : !this.streetName.equals(other.streetName));
    }

    public String toString() {
        ArrayList<Object> fields = new ArrayList<Object>();
        if (this.country.isPresent()) {
            fields.add(this.country.get());
        }
        if (this.city.isPresent()) {
            fields.add(this.city.get());
        }
        if (this.postCode.isPresent()) {
            fields.add(this.postCode.get());
        }
        if (this.streetName.isPresent()) {
            fields.add(this.streetName.get());
        }
        if (this.houseNumber.isPresent()) {
            fields.add(this.houseNumber.get());
        }
        return Joiner.on((String)"|").join(fields);
    }
}

