/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.ariadne.routeformat.instruction;

import at.ac.ait.ariadne.routeformat.Constants;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONCoordinate;
import at.ac.ait.ariadne.routeformat.instruction.Instruction;
import at.ac.ait.ariadne.routeformat.instruction.Landmark;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class RoundaboutInstruction
extends Instruction<RoundaboutInstruction> {
    private SubType subType;
    private Optional<Constants.CompassDirection> compassDirection = Optional.absent();
    private Optional<String> roundaboutStreetName = Optional.absent();
    private Optional<String> ontoStreetName = Optional.absent();
    private Optional<Constants.FormOfWay> ontoFormOfWay = Optional.absent();
    private Optional<Integer> exitNr = Optional.absent();
    private Optional<Integer> continueMeters = Optional.absent();
    private Optional<Integer> continueSeconds = Optional.absent();
    private Optional<String> continueUntilIntersectingStreetName = Optional.absent();
    private Optional<Landmark> landmark = Optional.absent();
    private Optional<Landmark> confirmationLandmark = Optional.absent();

    @JsonProperty(required=true)
    public SubType getSubType() {
        return this.subType;
    }

    public Optional<Constants.CompassDirection> getCompassDirection() {
        return this.compassDirection;
    }

    public Optional<String> getRoundaboutStreetName() {
        return this.roundaboutStreetName;
    }

    public Optional<String> getOntoStreetName() {
        return this.ontoStreetName;
    }

    public Optional<Constants.FormOfWay> getOntoFormOfWay() {
        return this.ontoFormOfWay;
    }

    public Optional<Integer> getExitNr() {
        return this.exitNr;
    }

    public Optional<Integer> getContinueMeters() {
        return this.continueMeters;
    }

    public Optional<Integer> getContinueSeconds() {
        return this.continueSeconds;
    }

    public Optional<String> getContinueUntilIntersectingStreetName() {
        return this.continueUntilIntersectingStreetName;
    }

    public Optional<Landmark> getLandmark() {
        return this.landmark;
    }

    public Optional<Landmark> getConfirmationLandmark() {
        return this.confirmationLandmark;
    }

    public RoundaboutInstruction setSubType(SubType subType) {
        this.subType = subType;
        return this;
    }

    public RoundaboutInstruction setCompassDirection(Constants.CompassDirection compassDirection) {
        this.compassDirection = Optional.fromNullable((Object)((Object)compassDirection));
        return this;
    }

    public RoundaboutInstruction setRoundaboutStreetName(String roundaboutStreetName) {
        this.roundaboutStreetName = Optional.fromNullable((Object)roundaboutStreetName);
        return this;
    }

    public RoundaboutInstruction setOntoStreetName(String ontoStreetName) {
        this.ontoStreetName = Optional.fromNullable((Object)ontoStreetName);
        return this;
    }

    public RoundaboutInstruction setOntoFormOfWay(Constants.FormOfWay ontoFormOfWay) {
        this.ontoFormOfWay = Optional.fromNullable((Object)((Object)ontoFormOfWay));
        return this;
    }

    public RoundaboutInstruction setExitNr(Integer exitNr) {
        this.exitNr = Optional.fromNullable((Object)exitNr);
        return this;
    }

    public RoundaboutInstruction setContinueMeters(Integer continueMeters) {
        this.continueMeters = Optional.fromNullable((Object)continueMeters);
        return this;
    }

    public RoundaboutInstruction setContinueSeconds(Integer continueSeconds) {
        this.continueSeconds = Optional.fromNullable((Object)continueSeconds);
        return this;
    }

    public RoundaboutInstruction setContinueUntilIntersectingStreetName(String continueUntilIntersectingStreetName) {
        this.continueUntilIntersectingStreetName = Optional.fromNullable((Object)continueUntilIntersectingStreetName);
        return this;
    }

    public RoundaboutInstruction setLandmark(Landmark landmark) {
        this.landmark = Optional.fromNullable((Object)landmark);
        return this;
    }

    public RoundaboutInstruction setConfirmationLandmark(Landmark confirmationLandmark) {
        this.confirmationLandmark = Optional.fromNullable((Object)confirmationLandmark);
        return this;
    }

    public static RoundaboutInstruction createMinimalEnter(GeoJSONCoordinate position) {
        return ((RoundaboutInstruction)new RoundaboutInstruction().setPosition(position)).setSubType(SubType.ENTER);
    }

    public static RoundaboutInstruction createMinimalExit(GeoJSONCoordinate position) {
        return ((RoundaboutInstruction)new RoundaboutInstruction().setPosition(position)).setSubType(SubType.EXIT);
    }

    @Override
    public void validate() {
        super.validate();
        Preconditions.checkArgument((this.subType != null ? 1 : 0) != 0, (Object)"subType is mandatory but missing");
        Preconditions.checkArgument((this.ontoStreetName.isPresent() || this.ontoFormOfWay.isPresent() ? 1 : 0) != 0, (Object)"at least one onto-type is required");
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.compassDirection == null ? 0 : this.compassDirection.hashCode());
        result = 31 * result + (this.confirmationLandmark == null ? 0 : this.confirmationLandmark.hashCode());
        result = 31 * result + (this.continueMeters == null ? 0 : this.continueMeters.hashCode());
        result = 31 * result + (this.continueSeconds == null ? 0 : this.continueSeconds.hashCode());
        result = 31 * result + (this.continueUntilIntersectingStreetName == null ? 0 : this.continueUntilIntersectingStreetName.hashCode());
        result = 31 * result + (this.exitNr == null ? 0 : this.exitNr.hashCode());
        result = 31 * result + (this.landmark == null ? 0 : this.landmark.hashCode());
        result = 31 * result + (this.ontoFormOfWay == null ? 0 : this.ontoFormOfWay.hashCode());
        result = 31 * result + (this.ontoStreetName == null ? 0 : this.ontoStreetName.hashCode());
        result = 31 * result + (this.roundaboutStreetName == null ? 0 : this.roundaboutStreetName.hashCode());
        result = 31 * result + (this.subType == null ? 0 : this.subType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RoundaboutInstruction other = (RoundaboutInstruction)obj;
        if (this.compassDirection == null ? other.compassDirection != null : !this.compassDirection.equals(other.compassDirection)) {
            return false;
        }
        if (this.confirmationLandmark == null ? other.confirmationLandmark != null : !this.confirmationLandmark.equals(other.confirmationLandmark)) {
            return false;
        }
        if (this.continueMeters == null ? other.continueMeters != null : !this.continueMeters.equals(other.continueMeters)) {
            return false;
        }
        if (this.continueSeconds == null ? other.continueSeconds != null : !this.continueSeconds.equals(other.continueSeconds)) {
            return false;
        }
        if (this.continueUntilIntersectingStreetName == null ? other.continueUntilIntersectingStreetName != null : !this.continueUntilIntersectingStreetName.equals(other.continueUntilIntersectingStreetName)) {
            return false;
        }
        if (this.exitNr == null ? other.exitNr != null : !this.exitNr.equals(other.exitNr)) {
            return false;
        }
        if (this.landmark == null ? other.landmark != null : !this.landmark.equals(other.landmark)) {
            return false;
        }
        if (this.ontoFormOfWay == null ? other.ontoFormOfWay != null : !this.ontoFormOfWay.equals(other.ontoFormOfWay)) {
            return false;
        }
        if (this.ontoStreetName == null ? other.ontoStreetName != null : !this.ontoStreetName.equals(other.ontoStreetName)) {
            return false;
        }
        if (this.roundaboutStreetName == null ? other.roundaboutStreetName != null : !this.roundaboutStreetName.equals(other.roundaboutStreetName)) {
            return false;
        }
        return this.subType == other.subType;
    }

    @Override
    public String toString() {
        return "RoundaboutInstruction [subType=" + (Object)((Object)this.subType) + ", compassDirection=" + this.compassDirection + ", roundaboutStreetName=" + this.roundaboutStreetName + ", ontoStreetName=" + this.ontoStreetName + ", ontoFormOfWay=" + this.ontoFormOfWay + ", exitNr=" + this.exitNr + ", continueMeters=" + this.continueMeters + ", continueSeconds=" + this.continueSeconds + ", continueUntilIntersectingStreetName=" + this.continueUntilIntersectingStreetName + ", landmark=" + this.landmark + ", confirmationLandmark=" + this.confirmationLandmark + "]";
    }

    public static enum SubType {
        ENTER,
        EXIT;

    }
}

