/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.ariadne.routeformat.instruction;

import at.ac.ait.ariadne.routeformat.Constants;
import at.ac.ait.ariadne.routeformat.Validatable;
import at.ac.ait.ariadne.routeformat.location.Location;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.TreeMap;

public class Landmark
implements Validatable {
    private Constants.Preposition preposition;
    private Location<?> location;
    private Optional<Constants.RelativeDirection> direction = Optional.absent();
    private Map<String, Object> additionalInfo = new TreeMap<String, Object>();

    @JsonProperty(required=true)
    public Constants.Preposition getPreposition() {
        return this.preposition;
    }

    @JsonProperty(required=true)
    public Location<?> getLocation() {
        return this.location;
    }

    public Optional<Constants.RelativeDirection> getDirection() {
        return this.direction;
    }

    public Map<String, Object> getAdditionalInfo() {
        return this.additionalInfo;
    }

    public Landmark setPreposition(Constants.Preposition preposition) {
        this.preposition = preposition;
        return this;
    }

    public Landmark setLocation(Location<?> location) {
        this.location = location;
        return this;
    }

    public Landmark setDirection(Constants.RelativeDirection direction) {
        this.direction = Optional.fromNullable((Object)((Object)direction));
        return this;
    }

    public Landmark setAdditionalInfo(Map<String, Object> additionalInfo) {
        this.additionalInfo = new TreeMap<String, Object>(additionalInfo);
        return this;
    }

    public static Landmark createMinimal(Constants.Preposition preposition, Location<?> location) {
        return new Landmark().setPreposition(preposition).setLocation(location);
    }

    public Landmark shallowCopy() {
        return new Landmark().setPreposition(this.preposition).setLocation(this.location).setDirection((Constants.RelativeDirection)((Object)this.direction.orNull())).setAdditionalInfo(this.additionalInfo);
    }

    @Override
    public void validate() {
        Preconditions.checkArgument((this.preposition != null ? 1 : 0) != 0, (Object)"preposition is mandatory but missing");
        Preconditions.checkArgument((this.location != null ? 1 : 0) != 0, (Object)"location is mandatory but missing");
        this.location.validate();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.additionalInfo == null ? 0 : this.additionalInfo.hashCode());
        result = 31 * result + (this.direction == null ? 0 : this.direction.hashCode());
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + (this.preposition == null ? 0 : this.preposition.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Landmark other = (Landmark)obj;
        if (this.additionalInfo == null ? other.additionalInfo != null : !this.additionalInfo.equals(other.additionalInfo)) {
            return false;
        }
        if (this.direction == null ? other.direction != null : !this.direction.equals(other.direction)) {
            return false;
        }
        if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
            return false;
        }
        return this.preposition == other.preposition;
    }

    public String toString() {
        return "Landmark [preposition=" + (Object)((Object)this.preposition) + ", location=" + this.location + ", direction=" + this.direction + ", additionalInfo=" + this.additionalInfo + "]";
    }
}

