/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.ariadne.routeformat.instruction;

import at.ac.ait.ariadne.routeformat.Constants;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONCoordinate;
import at.ac.ait.ariadne.routeformat.instruction.Instruction;
import at.ac.ait.ariadne.routeformat.instruction.Landmark;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class AreaInstruction
extends Instruction<AreaInstruction> {
    private SubType subType;
    private Optional<String> areaName = Optional.absent();
    private Optional<Constants.Area> areaType = Optional.absent();
    private Optional<String> exitStreetName = Optional.absent();
    private Optional<Landmark> exitLandmark = Optional.absent();

    public SubType getSubType() {
        return this.subType;
    }

    public Optional<String> getAreaName() {
        return this.areaName;
    }

    public Optional<Constants.Area> getAreaType() {
        return this.areaType;
    }

    public Optional<String> getExitStreetName() {
        return this.exitStreetName;
    }

    public Optional<Landmark> getExitLandmark() {
        return this.exitLandmark;
    }

    public AreaInstruction setSubType(SubType subType) {
        this.subType = subType;
        return this;
    }

    public AreaInstruction setAreaName(String areaName) {
        this.areaName = Optional.fromNullable((Object)areaName);
        return this;
    }

    public AreaInstruction setAreaType(Constants.Area areaType) {
        this.areaType = Optional.fromNullable((Object)((Object)areaType));
        return this;
    }

    public AreaInstruction setExitStreetName(String exitStreetName) {
        this.exitStreetName = Optional.fromNullable((Object)exitStreetName);
        return this;
    }

    public AreaInstruction setExitLandmark(Landmark exitLandmark) {
        this.exitLandmark = Optional.fromNullable((Object)exitLandmark);
        return this;
    }

    public static AreaInstruction createMinimalEnter(GeoJSONCoordinate position) {
        return ((AreaInstruction)new AreaInstruction().setPosition(position)).setSubType(SubType.ENTER);
    }

    public static AreaInstruction createMinimalExit(GeoJSONCoordinate position) {
        return ((AreaInstruction)new AreaInstruction().setPosition(position)).setSubType(SubType.EXIT);
    }

    @Override
    public void validate() {
        super.validate();
        Preconditions.checkArgument((this.subType != null ? 1 : 0) != 0, (Object)"subType is mandatory but missing");
        Preconditions.checkArgument((this.areaName.isPresent() || this.areaType.isPresent() ? 1 : 0) != 0, (Object)"at least one of area name and area type is required");
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.areaName == null ? 0 : this.areaName.hashCode());
        result = 31 * result + (this.areaType == null ? 0 : this.areaType.hashCode());
        result = 31 * result + (this.exitLandmark == null ? 0 : this.exitLandmark.hashCode());
        result = 31 * result + (this.exitStreetName == null ? 0 : this.exitStreetName.hashCode());
        result = 31 * result + (this.subType == null ? 0 : this.subType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AreaInstruction other = (AreaInstruction)obj;
        if (this.areaName == null ? other.areaName != null : !this.areaName.equals(other.areaName)) {
            return false;
        }
        if (this.areaType == null ? other.areaType != null : !this.areaType.equals(other.areaType)) {
            return false;
        }
        if (this.exitLandmark == null ? other.exitLandmark != null : !this.exitLandmark.equals(other.exitLandmark)) {
            return false;
        }
        if (this.exitStreetName == null ? other.exitStreetName != null : !this.exitStreetName.equals(other.exitStreetName)) {
            return false;
        }
        return this.subType == other.subType;
    }

    @Override
    public String toString() {
        return super.toString() + " -> AreaInstruction [subType=" + (Object)((Object)this.subType) + ", areaName=" + this.areaName + ", areaType=" + this.areaType + ", exitStreetName=" + this.exitStreetName + ", exitLandmark=" + this.exitLandmark + "]";
    }

    public static enum SubType {
        ENTER,
        EXIT;

    }
}

