/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.ariadne.routeformat.geojson;

import at.ac.ait.ariadne.routeformat.geojson.GeoJSONCoordinate;
import com.google.common.base.Joiner;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;

class WKTUtil {
    WKTUtil() {
    }

    public static String getCoordinateStringPointOrLineString(List<GeoJSONCoordinate> coordinates) {
        if (coordinates.isEmpty()) {
            return "EMPTY";
        }
        StringBuilder sb = new StringBuilder();
        if (coordinates.isEmpty()) {
            sb.append("EMPTY");
        } else {
            sb.append("(");
            ArrayList<String> xyzTuples = new ArrayList<String>();
            for (GeoJSONCoordinate c : coordinates) {
                xyzTuples.add(WKTUtil.getCoordinateString(c));
            }
            sb.append(Joiner.on((String)", ").join(xyzTuples));
            sb.append(")");
        }
        return sb.toString();
    }

    public static String getCoordinateStringPolygon(List<List<GeoJSONCoordinate>> coordinates) {
        if (coordinates.isEmpty()) {
            return "EMPTY";
        }
        ArrayList<String> tokens = new ArrayList<String>();
        for (List<GeoJSONCoordinate> c : coordinates) {
            tokens.add(WKTUtil.getCoordinateStringPointOrLineString(c));
        }
        StringBuilder sb = new StringBuilder("(");
        sb.append(Joiner.on((String)", ").join(tokens));
        sb.append(")");
        return sb.toString();
    }

    public static String getCoordinateStringMultiPolygon(List<List<List<GeoJSONCoordinate>>> coordinates) {
        if (coordinates.isEmpty()) {
            return "EMPTY";
        }
        ArrayList<String> tokens = new ArrayList<String>();
        for (List<List<GeoJSONCoordinate>> c : coordinates) {
            tokens.add(WKTUtil.getCoordinateStringPolygon(c));
        }
        StringBuilder sb = new StringBuilder("(");
        sb.append(Joiner.on((String)", ").join(tokens));
        sb.append(")");
        return sb.toString();
    }

    private static String getCoordinateString(GeoJSONCoordinate coordinate) {
        DecimalFormat df = new DecimalFormat("#.#######");
        DecimalFormatSymbols custom = new DecimalFormatSymbols();
        custom.setDecimalSeparator('.');
        df.setDecimalFormatSymbols(custom);
        ArrayList<String> subStrings = new ArrayList<String>();
        subStrings.add(df.format(coordinate.getX()));
        subStrings.add(df.format(coordinate.getY()));
        return Joiner.on((char)' ').join(subStrings);
    }
}

