/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.ariadne.routeformat.geojson;

import at.ac.ait.ariadne.routeformat.Validatable;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONCoordinate;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONGeometryObject;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONLineString;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONMultiPolygon;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONPoint;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONPolygon;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONUtil;
import at.ac.ait.ariadne.routeformat.location.Location;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class GeoJSONFeature<T extends GeoJSONGeometryObject>
implements Validatable {
    @JsonProperty(required=true)
    public final String type = GeoJSONUtil.getTypeName(this.getClass());
    private T geometry;
    private Map<String, Object> properties = new TreeMap<String, Object>();

    @JsonProperty(required=true)
    public T getGeometry() {
        return this.geometry;
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(required=true)
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public GeoJSONFeature<T> setGeometry(T geometry) {
        this.geometry = geometry;
        return this;
    }

    public GeoJSONFeature<T> setProperties(Map<String, Object> properties) {
        this.properties = new TreeMap<String, Object>(properties);
        return this;
    }

    public static GeoJSONFeature<GeoJSONPoint> createPointFeature(GeoJSONCoordinate point) {
        return GeoJSONFeature.createPointFeature(GeoJSONPoint.create(point));
    }

    public static GeoJSONFeature<GeoJSONPoint> createPointFeature(GeoJSONPoint point) {
        return new GeoJSONFeature<GeoJSONPoint>().setGeometry(point);
    }

    public static GeoJSONFeature<GeoJSONLineString> createLineStringFeature(Location<?> from, Location<?> to, GeoJSONCoordinate ... geometryInbetween) {
        ArrayList<GeoJSONCoordinate> coordinatePoints = new ArrayList<GeoJSONCoordinate>();
        coordinatePoints.add((GeoJSONCoordinate)((GeoJSONPoint)from.getCoordinate().geometry).getCoordinates().get());
        coordinatePoints.addAll(Arrays.asList(geometryInbetween));
        coordinatePoints.add((GeoJSONCoordinate)((GeoJSONPoint)to.getCoordinate().geometry).getCoordinates().get());
        return GeoJSONFeature.createLineStringFeature(coordinatePoints);
    }

    public static GeoJSONFeature<GeoJSONLineString> createLineStringFeature(List<GeoJSONCoordinate> points) {
        return GeoJSONFeature.createLineStringFeature(GeoJSONLineString.create(points));
    }

    public static GeoJSONFeature<GeoJSONLineString> createLineStringFeature(GeoJSONLineString lineString) {
        return new GeoJSONFeature<GeoJSONLineString>().setGeometry(lineString);
    }

    public static GeoJSONFeature<GeoJSONPolygon> createPolygonFeatureFromRings(List<GeoJSONCoordinate> outerRing, List<List<GeoJSONCoordinate>> innerRings) {
        ArrayList<List<GeoJSONCoordinate>> rings = new ArrayList<List<GeoJSONCoordinate>>();
        rings.add(outerRing);
        rings.addAll(innerRings);
        return GeoJSONFeature.createPolygonFeatureFromCoordinatePoints(rings);
    }

    public static GeoJSONFeature<GeoJSONPolygon> createPolygonFeatureFromCoordinatePoints(List<List<GeoJSONCoordinate>> points) {
        return GeoJSONFeature.createPolygonFeature(GeoJSONPolygon.create(points));
    }

    public static GeoJSONFeature<GeoJSONPolygon> createPolygonFeature(GeoJSONPolygon polygon) {
        return new GeoJSONFeature<GeoJSONPolygon>().setGeometry(polygon);
    }

    public static GeoJSONFeature<GeoJSONMultiPolygon> createMultiPolygonFeatureFromPolygons(List<GeoJSONFeature<GeoJSONPolygon>> polygons) {
        ArrayList<List<List<GeoJSONCoordinate>>> polygonGeometries = new ArrayList<List<List<GeoJSONCoordinate>>>();
        for (GeoJSONFeature<GeoJSONPolygon> polygon : polygons) {
            polygonGeometries.add(((GeoJSONPolygon)polygon.geometry).getCoordinates());
        }
        return new GeoJSONFeature<GeoJSONMultiPolygon>().setGeometry(GeoJSONMultiPolygon.create(polygonGeometries));
    }

    @Override
    public void validate() {
        Preconditions.checkArgument((this.geometry != null ? 1 : 0) != 0, (Object)"geometry is mandatory but missing");
        this.geometry.validate();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.geometry == null ? 0 : this.geometry.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeoJSONFeature other = (GeoJSONFeature)obj;
        if (this.geometry == null ? other.geometry != null : !this.geometry.equals(other.geometry)) {
            return false;
        }
        if (this.properties == null ? other.properties != null : !this.properties.equals(other.properties)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public String toWKT() {
        return this.geometry.toWKT();
    }

    public String toString() {
        return "GeoJSONFeature [geometryWKT=" + this.toWKT() + ", properties=" + this.properties + "]";
    }
}

