/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.ariadne.routeformat.features;

import at.ac.ait.ariadne.routeformat.Constants;
import at.ac.ait.ariadne.routeformat.ModeOfTransport;
import at.ac.ait.ariadne.routeformat.Validatable;
import at.ac.ait.ariadne.routeformat.features.OptimizedFor;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONFeature;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONPoint;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONPolygon;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Site
implements Validatable {
    private String id;
    private Optional<String> name = Optional.absent();
    private List<OptimizedFor> optimizedFor = new ArrayList<OptimizedFor>();
    private List<ModeOfTransport> modesOfTransport = new ArrayList<ModeOfTransport>();
    private Optional<GeoJSONFeature<GeoJSONPoint>> focusPoint = Optional.absent();
    private Optional<Integer> zoomLevel = Optional.absent();
    private Optional<GeoJSONFeature<GeoJSONPolygon>> boundingPolygon = Optional.absent();
    private List<Constants.SiteFeature> features = new ArrayList<Constants.SiteFeature>();
    private Map<String, Object> additionalInfo = new TreeMap<String, Object>();

    @JsonProperty(required=true)
    public String getId() {
        return this.id;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public List<OptimizedFor> getOptimizedFor() {
        return this.optimizedFor;
    }

    public List<ModeOfTransport> getModesOfTransport() {
        return this.modesOfTransport;
    }

    public Optional<GeoJSONFeature<GeoJSONPoint>> getFocusPoint() {
        return this.focusPoint;
    }

    public Optional<Integer> getZoomLevel() {
        return this.zoomLevel;
    }

    public Optional<GeoJSONFeature<GeoJSONPolygon>> getBoundingPolygon() {
        return this.boundingPolygon;
    }

    public List<Constants.SiteFeature> getFeatures() {
        return this.features;
    }

    public Map<String, Object> getAdditionalInfo() {
        return this.additionalInfo;
    }

    public Site setId(String id) {
        this.id = id;
        return this;
    }

    public Site setName(String name) {
        this.name = Optional.fromNullable((Object)name);
        return this;
    }

    public Site setOptimizedFor(List<OptimizedFor> optimizedFor) {
        this.optimizedFor = new ArrayList<OptimizedFor>(optimizedFor);
        return this;
    }

    public Site setModesOfTransport(List<ModeOfTransport> modesOfTransport) {
        this.modesOfTransport = new ArrayList<ModeOfTransport>(modesOfTransport);
        return this;
    }

    public Site setFocusPoint(GeoJSONFeature<GeoJSONPoint> focusPoint) {
        this.focusPoint = Optional.fromNullable(focusPoint);
        return this;
    }

    public Site setZoomLevel(Integer zoomLevel) {
        this.zoomLevel = Optional.fromNullable((Object)zoomLevel);
        return this;
    }

    public Site setBoundingPolygon(GeoJSONFeature<GeoJSONPolygon> boundingPolygon) {
        this.boundingPolygon = Optional.fromNullable(boundingPolygon);
        return this;
    }

    public Site setFeatures(List<Constants.SiteFeature> features) {
        this.features = new ArrayList<Constants.SiteFeature>(features);
        return this;
    }

    public Site setAdditionalInfo(Map<String, Object> additionalInfo) {
        this.additionalInfo = new TreeMap<String, Object>(additionalInfo);
        return this;
    }

    public static Site createMinimal(String id) {
        return new Site().setId(id);
    }

    public static Site createShallowCopy(Site s) {
        Site copy = Site.createMinimal(s.getId()).setOptimizedFor(s.getOptimizedFor()).setModesOfTransport(s.getModesOfTransport()).setAdditionalInfo(s.getAdditionalInfo());
        copy.setName((String)s.getName().orNull());
        copy.setFocusPoint((GeoJSONFeature)s.getFocusPoint().orNull());
        copy.setZoomLevel((Integer)s.getZoomLevel().orNull());
        copy.setBoundingPolygon((GeoJSONFeature)s.getBoundingPolygon().orNull());
        return copy;
    }

    @Override
    public void validate() {
        Preconditions.checkArgument((this.id != null ? 1 : 0) != 0, (Object)"id is mandatory but missing");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.additionalInfo == null ? 0 : this.additionalInfo.hashCode());
        result = 31 * result + (this.boundingPolygon == null ? 0 : this.boundingPolygon.hashCode());
        result = 31 * result + (this.features == null ? 0 : this.features.hashCode());
        result = 31 * result + (this.focusPoint == null ? 0 : this.focusPoint.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.modesOfTransport == null ? 0 : this.modesOfTransport.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.optimizedFor == null ? 0 : this.optimizedFor.hashCode());
        result = 31 * result + (this.zoomLevel == null ? 0 : this.zoomLevel.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Site other = (Site)obj;
        if (this.additionalInfo == null ? other.additionalInfo != null : !this.additionalInfo.equals(other.additionalInfo)) {
            return false;
        }
        if (this.boundingPolygon == null ? other.boundingPolygon != null : !this.boundingPolygon.equals(other.boundingPolygon)) {
            return false;
        }
        if (this.features == null ? other.features != null : !this.features.equals(other.features)) {
            return false;
        }
        if (this.focusPoint == null ? other.focusPoint != null : !this.focusPoint.equals(other.focusPoint)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.modesOfTransport == null ? other.modesOfTransport != null : !this.modesOfTransport.equals(other.modesOfTransport)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.optimizedFor == null ? other.optimizedFor != null : !this.optimizedFor.equals(other.optimizedFor)) {
            return false;
        }
        return !(this.zoomLevel == null ? other.zoomLevel != null : !this.zoomLevel.equals(other.zoomLevel));
    }

    public String toString() {
        return "Site [id=" + this.id + ", name=" + this.name + ", optimizedFor=" + this.optimizedFor + ", modesOfTransport=" + this.modesOfTransport + ", focusPoint=" + this.focusPoint + ", zoomLevel=" + this.zoomLevel + ", boundingPolygon=" + this.boundingPolygon + ", siteFeatures=" + this.features + ", additionalInfo=" + this.additionalInfo + "]";
    }
}

