/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.ariadne.routeformat.instruction;

import at.ac.ait.ariadne.routeformat.Constants;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONCoordinate;
import at.ac.ait.ariadne.routeformat.instruction.Instruction;
import at.ac.ait.ariadne.routeformat.instruction.Landmark;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class RoundaboutInstruction
extends Instruction<RoundaboutInstruction> {
    private SubType subType;
    private Optional<Constants.CompassDirection> compassDirection = Optional.empty();
    private Optional<String> roundaboutStreetName = Optional.empty();
    private Optional<String> ontoStreetName = Optional.empty();
    private Optional<Constants.FormOfWay> ontoFormOfWay = Optional.empty();
    private Optional<Integer> exitNr = Optional.empty();
    private Optional<Integer> continueMeters = Optional.empty();
    private Optional<Integer> continueSeconds = Optional.empty();
    private Optional<String> continueUntilIntersectingStreetName = Optional.empty();
    private Optional<Landmark> landmark = Optional.empty();
    private Optional<Landmark> confirmationLandmark = Optional.empty();

    @JsonProperty(required=true)
    public SubType getSubType() {
        return this.subType;
    }

    public Optional<Constants.CompassDirection> getCompassDirection() {
        return this.compassDirection;
    }

    public Optional<String> getRoundaboutStreetName() {
        return this.roundaboutStreetName;
    }

    public Optional<String> getOntoStreetName() {
        return this.ontoStreetName;
    }

    public Optional<Constants.FormOfWay> getOntoFormOfWay() {
        return this.ontoFormOfWay;
    }

    public Optional<Integer> getExitNr() {
        return this.exitNr;
    }

    public Optional<Integer> getContinueMeters() {
        return this.continueMeters;
    }

    public Optional<Integer> getContinueSeconds() {
        return this.continueSeconds;
    }

    public Optional<String> getContinueUntilIntersectingStreetName() {
        return this.continueUntilIntersectingStreetName;
    }

    public Optional<Landmark> getLandmark() {
        return this.landmark;
    }

    public Optional<Landmark> getConfirmationLandmark() {
        return this.confirmationLandmark;
    }

    public RoundaboutInstruction setSubType(SubType subType) {
        this.subType = subType;
        return this;
    }

    public RoundaboutInstruction setCompassDirection(Constants.CompassDirection compassDirection) {
        this.compassDirection = Optional.ofNullable(compassDirection);
        return this;
    }

    public RoundaboutInstruction setRoundaboutStreetName(String roundaboutStreetName) {
        this.roundaboutStreetName = Optional.ofNullable(roundaboutStreetName);
        return this;
    }

    public RoundaboutInstruction setOntoStreetName(String ontoStreetName) {
        this.ontoStreetName = Optional.ofNullable(ontoStreetName);
        return this;
    }

    public RoundaboutInstruction setOntoFormOfWay(Constants.FormOfWay ontoFormOfWay) {
        this.ontoFormOfWay = Optional.ofNullable(ontoFormOfWay);
        return this;
    }

    public RoundaboutInstruction setExitNr(Integer exitNr) {
        this.exitNr = Optional.ofNullable(exitNr);
        return this;
    }

    public RoundaboutInstruction setContinueMeters(Integer continueMeters) {
        this.continueMeters = Optional.ofNullable(continueMeters);
        return this;
    }

    public RoundaboutInstruction setContinueSeconds(Integer continueSeconds) {
        this.continueSeconds = Optional.ofNullable(continueSeconds);
        return this;
    }

    public RoundaboutInstruction setContinueUntilIntersectingStreetName(String continueUntilIntersectingStreetName) {
        this.continueUntilIntersectingStreetName = Optional.ofNullable(continueUntilIntersectingStreetName);
        return this;
    }

    public RoundaboutInstruction setLandmark(Landmark landmark) {
        this.landmark = Optional.ofNullable(landmark);
        return this;
    }

    public RoundaboutInstruction setConfirmationLandmark(Landmark confirmationLandmark) {
        this.confirmationLandmark = Optional.ofNullable(confirmationLandmark);
        return this;
    }

    public static RoundaboutInstruction createMinimalEnter(GeoJSONCoordinate position) {
        return ((RoundaboutInstruction)new RoundaboutInstruction().setPosition(position)).setSubType(SubType.ENTER);
    }

    public static RoundaboutInstruction createMinimalExit(GeoJSONCoordinate position) {
        return ((RoundaboutInstruction)new RoundaboutInstruction().setPosition(position)).setSubType(SubType.EXIT);
    }

    @Override
    public void validate() {
        super.validate();
        Preconditions.checkArgument((this.subType != null ? 1 : 0) != 0, (Object)"subType is mandatory but missing");
        Preconditions.checkArgument((this.ontoStreetName.isPresent() || this.ontoFormOfWay.isPresent() ? 1 : 0) != 0, (Object)"at least one onto-type is required");
    }

    @Override
    public String toString() {
        return "RoundaboutInstruction [subType=" + (Object)((Object)this.subType) + ", compassDirection=" + this.compassDirection + ", roundaboutStreetName=" + this.roundaboutStreetName + ", ontoStreetName=" + this.ontoStreetName + ", ontoFormOfWay=" + this.ontoFormOfWay + ", exitNr=" + this.exitNr + ", continueMeters=" + this.continueMeters + ", continueSeconds=" + this.continueSeconds + ", continueUntilIntersectingStreetName=" + this.continueUntilIntersectingStreetName + ", landmark=" + this.landmark + ", confirmationLandmark=" + this.confirmationLandmark + "]";
    }

    public static enum SubType {
        ENTER,
        EXIT;

    }
}

