/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.ariadne.routeformat.instruction;

import at.ac.ait.ariadne.routeformat.Constants;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONCoordinate;
import at.ac.ait.ariadne.routeformat.instruction.Instruction;
import at.ac.ait.ariadne.routeformat.instruction.Landmark;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.base.Preconditions;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class RoadCrossingInstruction
extends Instruction<RoadCrossingInstruction> {
    private Constants.TurnDirection turnDirection;
    private Optional<Landmark> landmark = Optional.empty();
    private Optional<Constants.RoadCrossing> roadCrossing = Optional.empty();

    public Constants.TurnDirection getTurnDirection() {
        return this.turnDirection;
    }

    public Optional<Landmark> getLandmark() {
        return this.landmark;
    }

    public Optional<Constants.RoadCrossing> getRoadCrossing() {
        return this.roadCrossing;
    }

    public RoadCrossingInstruction setTurnDirection(Constants.TurnDirection turnDirection) {
        this.turnDirection = turnDirection;
        return this;
    }

    public RoadCrossingInstruction setLandmark(Landmark landmark) {
        this.landmark = Optional.ofNullable(landmark);
        return this;
    }

    public RoadCrossingInstruction setRoadCrossing(Constants.RoadCrossing roadCrossing) {
        this.roadCrossing = Optional.ofNullable(roadCrossing);
        return this;
    }

    public static RoadCrossingInstruction createMinimal(GeoJSONCoordinate position, Constants.TurnDirection turnDirection) {
        return ((RoadCrossingInstruction)new RoadCrossingInstruction().setPosition(position)).setTurnDirection(turnDirection);
    }

    @Override
    public void validate() {
        super.validate();
        Preconditions.checkArgument((this.turnDirection != null ? 1 : 0) != 0, (Object)"turnDirection is mandatory but missing");
    }

    @Override
    public String toString() {
        return super.toString() + " -> RoadCrossingInstruction [turnDirection=" + (Object)((Object)this.turnDirection) + ", landmark=" + this.landmark + ", roadCrossing=" + this.roadCrossing + "]";
    }
}

