/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.ariadne.routeformat.geojson;

import at.ac.ait.ariadne.routeformat.geojson.GeoJSONCoordinate;
import com.google.common.base.Joiner;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

class WKTUtil {
    WKTUtil() {
    }

    public static String getCoordinateStringPointOrLineString(List<GeoJSONCoordinate> coordinates) {
        if (coordinates.isEmpty()) {
            return "EMPTY";
        }
        StringBuilder sb = new StringBuilder();
        if (coordinates.isEmpty()) {
            sb.append("EMPTY");
        } else {
            sb.append("(");
            List xyzTuples = coordinates.stream().map(xyz -> WKTUtil.getCoordinateString(xyz)).collect(Collectors.toList());
            sb.append(Joiner.on((String)", ").join(xyzTuples));
            sb.append(")");
        }
        return sb.toString();
    }

    public static String getCoordinateStringPolygon(List<List<GeoJSONCoordinate>> coordinates) {
        if (coordinates.isEmpty()) {
            return "EMPTY";
        }
        StringBuilder sb = new StringBuilder("(");
        sb.append(Joiner.on((String)", ").join((Iterable)coordinates.stream().map(c -> WKTUtil.getCoordinateStringPointOrLineString(c)).collect(Collectors.toList())));
        sb.append(")");
        return sb.toString();
    }

    public static String getCoordinateStringMultiPolygon(List<List<List<GeoJSONCoordinate>>> coordinates) {
        if (coordinates.isEmpty()) {
            return "EMPTY";
        }
        StringBuilder sb = new StringBuilder("(");
        sb.append(Joiner.on((String)", ").join((Iterable)coordinates.stream().map(c -> WKTUtil.getCoordinateStringPolygon(c)).collect(Collectors.toList())));
        sb.append(")");
        return sb.toString();
    }

    private static String getCoordinateString(GeoJSONCoordinate coordinate) {
        DecimalFormat df = new DecimalFormat("#.#######");
        DecimalFormatSymbols custom = new DecimalFormatSymbols();
        custom.setDecimalSeparator('.');
        df.setDecimalFormatSymbols(custom);
        ArrayList<String> subStrings = new ArrayList<String>();
        subStrings.add(df.format(coordinate.getX()));
        subStrings.add(df.format(coordinate.getY()));
        return Joiner.on((char)' ').join(subStrings);
    }
}

