/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.ariadne.routeformat.geojson;

import at.ac.ait.ariadne.routeformat.geojson.GeoJSONCoordinate;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONGeometryObject;
import at.ac.ait.ariadne.routeformat.geojson.WKTUtil;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.ALWAYS)
public class GeoJSONPoint
implements GeoJSONGeometryObject {
    private Optional<GeoJSONCoordinate> coordinates = Optional.empty();

    @JsonProperty(required=true)
    public Optional<GeoJSONCoordinate> getCoordinates() {
        return this.coordinates;
    }

    public GeoJSONPoint setCoordinates(GeoJSONCoordinate coordinates) {
        this.coordinates = Optional.ofNullable(coordinates);
        return this;
    }

    public static GeoJSONPoint create(GeoJSONCoordinate point) {
        return new GeoJSONPoint().setCoordinates(point);
    }

    @Override
    public boolean isEmpty() {
        return !this.coordinates.isPresent();
    }

    @Override
    public void validate() {
    }

    @Override
    public String toWKT() {
        List<GeoJSONCoordinate> list = this.coordinates.isPresent() ? Arrays.asList(this.coordinates.get()) : Collections.emptyList();
        return this.getTypeName() + " " + WKTUtil.getCoordinateStringPointOrLineString(list);
    }

    public String toString() {
        return this.toWKT();
    }
}

