/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.ariadne.routeformat;

import at.ac.ait.ariadne.routeformat.Constants;
import at.ac.ait.ariadne.routeformat.IntermediateStop;
import at.ac.ait.ariadne.routeformat.ModeOfTransport;
import at.ac.ait.ariadne.routeformat.Validatable;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONFeature;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONFeatureCollection;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONLineString;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONPolygon;
import at.ac.ait.ariadne.routeformat.instruction.Instruction;
import at.ac.ait.ariadne.routeformat.location.Location;
import at.ac.ait.ariadne.routeformat.util.Utils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class RouteSegment
implements Validatable {
    private static final Logger LOGGER = LoggerFactory.getLogger(RouteSegment.class);
    private Integer nr;
    private Location<?> from;
    private Location<?> to;
    private Integer distanceMeters;
    private Integer durationSeconds;
    private ModeOfTransport modeOfTransport;
    private Optional<Integer> boardingSeconds = Optional.empty();
    private Optional<Integer> alightingSeconds = Optional.empty();
    private ZonedDateTime startTime = null;
    private ZonedDateTime endTime = null;
    private List<IntermediateStop> intermediateStops = new ArrayList<IntermediateStop>();
    private Optional<GeoJSONFeature<GeoJSONPolygon>> boundingBox = Optional.empty();
    private Optional<String> geometryEncodedPolyLine = Optional.empty();
    private Optional<GeoJSONFeature<GeoJSONLineString>> geometryGeoJson = Optional.empty();
    private Optional<GeoJSONFeatureCollection<GeoJSONLineString>> geometryGeoJsonEdges = Optional.empty();
    private List<Instruction<?>> navigationInstructions = new ArrayList();
    private List<Constants.Accessibility> accessibility = new ArrayList<Constants.Accessibility>();
    private Map<String, Object> additionalInfo = new TreeMap<String, Object>();

    @JsonProperty(required=true)
    public int getNr() {
        return this.nr;
    }

    @JsonProperty(required=true)
    public Location<?> getFrom() {
        return this.from;
    }

    @JsonProperty(required=true)
    public Location<?> getTo() {
        return this.to;
    }

    @JsonProperty(required=true)
    public int getDistanceMeters() {
        return this.distanceMeters;
    }

    @JsonProperty(required=true)
    public int getDurationSeconds() {
        return this.durationSeconds;
    }

    @JsonIgnore
    public int getTravelTimeSeconds() {
        return this.durationSeconds - this.boardingSeconds.orElse(0) - this.alightingSeconds.orElse(0);
    }

    @JsonProperty(required=true)
    public ModeOfTransport getModeOfTransport() {
        return this.modeOfTransport;
    }

    public Optional<Integer> getBoardingSeconds() {
        return this.boardingSeconds;
    }

    public Optional<Integer> getAlightingSeconds() {
        return this.alightingSeconds;
    }

    public String getStartTime() {
        return this.startTime.toString();
    }

    @JsonIgnore
    public ZonedDateTime getStartTimeAsZonedDateTime() {
        return this.startTime;
    }

    @JsonIgnore
    public ZonedDateTime getDepartureTimeAsZonedDateTime() {
        return this.startTime.plusSeconds(this.boardingSeconds.orElse(0).intValue());
    }

    @JsonIgnore
    public ZonedDateTime getArrivalTimeAsZonedDateTime() {
        return this.endTime.minusSeconds(this.alightingSeconds.orElse(0).intValue());
    }

    public String getEndTime() {
        return this.endTime.toString();
    }

    @JsonIgnore
    public ZonedDateTime getEndTimeAsZonedDateTime() {
        return this.endTime;
    }

    public List<IntermediateStop> getIntermediateStops() {
        return this.intermediateStops;
    }

    public Optional<GeoJSONFeature<GeoJSONPolygon>> getBoundingBox() {
        return this.boundingBox;
    }

    public Optional<String> getGeometryEncodedPolyLine() {
        return this.geometryEncodedPolyLine;
    }

    public Optional<GeoJSONFeature<GeoJSONLineString>> getGeometryGeoJson() {
        return this.geometryGeoJson;
    }

    public Optional<GeoJSONFeatureCollection<GeoJSONLineString>> getGeometryGeoJsonEdges() {
        return this.geometryGeoJsonEdges;
    }

    public List<Instruction<?>> getNavigationInstructions() {
        return this.navigationInstructions;
    }

    public List<Constants.Accessibility> getAccessibility() {
        return this.accessibility;
    }

    public Map<String, Object> getAdditionalInfo() {
        return this.additionalInfo;
    }

    public RouteSegment setNr(int nr) {
        this.nr = nr;
        return this;
    }

    public RouteSegment setFrom(Location<?> from) {
        this.from = from;
        return this;
    }

    public RouteSegment setTo(Location<?> to) {
        this.to = to;
        return this;
    }

    public RouteSegment setDistanceMeters(int distanceMeters) {
        this.distanceMeters = distanceMeters;
        return this;
    }

    public RouteSegment setDurationSeconds(int durationSeconds) {
        this.durationSeconds = durationSeconds;
        return this;
    }

    public RouteSegment setModeOfTransport(ModeOfTransport modeOfTransport) {
        this.modeOfTransport = modeOfTransport;
        return this;
    }

    public RouteSegment setBoardingSeconds(Integer boardingSeconds) {
        this.boardingSeconds = Optional.ofNullable(boardingSeconds);
        return this;
    }

    public RouteSegment setAlightingSeconds(Integer alightingSeconds) {
        this.alightingSeconds = Optional.ofNullable(alightingSeconds);
        return this;
    }

    @JsonIgnore
    public RouteSegment setStartTime(ZonedDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    @JsonProperty
    public RouteSegment setStartTime(String startTime) {
        this.startTime = Utils.parseZonedDateTime(startTime, "startTime");
        return this;
    }

    @JsonIgnore
    public RouteSegment setEndTime(ZonedDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    @JsonProperty
    public RouteSegment setEndTime(String endTime) {
        this.endTime = Utils.parseZonedDateTime(endTime, "endTime");
        return this;
    }

    public RouteSegment setIntermediateStops(List<IntermediateStop> intermediateStops) {
        this.intermediateStops = new ArrayList<IntermediateStop>(intermediateStops);
        return this;
    }

    public RouteSegment setBoundingBox(GeoJSONFeature<GeoJSONPolygon> boundingBox) {
        this.boundingBox = Optional.ofNullable(boundingBox);
        return this;
    }

    public RouteSegment setGeometryEncodedPolyLine(String geometryEncodedPolyLine) {
        this.geometryEncodedPolyLine = Optional.ofNullable(geometryEncodedPolyLine);
        return this;
    }

    public RouteSegment setGeometryGeoJson(GeoJSONFeature<GeoJSONLineString> geometryGeoJson) {
        this.geometryGeoJson = Optional.ofNullable(geometryGeoJson);
        return this;
    }

    public RouteSegment setGeometryGeoJsonEdges(GeoJSONFeatureCollection<GeoJSONLineString> geometryGeoJsonEdges) {
        this.geometryGeoJsonEdges = Optional.ofNullable(geometryGeoJsonEdges);
        return this;
    }

    public RouteSegment setNavigationInstructions(List<Instruction<?>> navigationInstructions) {
        this.navigationInstructions = new ArrayList(navigationInstructions);
        return this;
    }

    public RouteSegment setAccessibility(List<Constants.Accessibility> accessibility) {
        this.accessibility = new ArrayList<Constants.Accessibility>(accessibility);
        return this;
    }

    public RouteSegment setAdditionalInfo(Map<String, Object> additionalInfo) {
        this.additionalInfo = new TreeMap<String, Object>(additionalInfo);
        return this;
    }

    public RouteSegment shiftInTime(long amountToAdd, ChronoUnit unit) {
        if (this.startTime != null) {
            this.startTime = this.startTime.plus(amountToAdd, unit);
        }
        if (this.endTime != null) {
            this.endTime = this.endTime.plus(amountToAdd, unit);
        }
        return this;
    }

    public static RouteSegment createShallowCopy(RouteSegment s) {
        RouteSegment copy = new RouteSegment().setNr(s.getNr()).setFrom(s.getFrom()).setTo(s.getTo()).setDistanceMeters(s.getDistanceMeters()).setDurationSeconds(s.getDurationSeconds()).setModeOfTransport(s.getModeOfTransport());
        s.getBoardingSeconds().ifPresent(b -> copy.setBoardingSeconds((Integer)b));
        s.getAlightingSeconds().ifPresent(a -> copy.setAlightingSeconds((Integer)a));
        copy.setStartTime(s.getStartTimeAsZonedDateTime()).setEndTime(s.getEndTimeAsZonedDateTime()).setIntermediateStops(s.getIntermediateStops());
        s.getBoundingBox().ifPresent(b -> copy.setBoundingBox((GeoJSONFeature<GeoJSONPolygon>)b));
        s.getGeometryEncodedPolyLine().ifPresent(g -> copy.setGeometryEncodedPolyLine((String)g));
        s.getGeometryGeoJson().ifPresent(g -> copy.setGeometryGeoJson((GeoJSONFeature<GeoJSONLineString>)g));
        s.getGeometryGeoJsonEdges().ifPresent(g -> copy.setGeometryGeoJsonEdges((GeoJSONFeatureCollection<GeoJSONLineString>)g));
        copy.setNavigationInstructions(s.getNavigationInstructions()).setAccessibility(s.getAccessibility()).setAdditionalInfo(s.getAdditionalInfo());
        return copy;
    }

    @Override
    public void validate() {
        this.validate(false);
    }

    public void validate(boolean strongValidation) {
        Preconditions.checkArgument((this.nr != null ? 1 : 0) != 0, (Object)"nr is mandatory but missing");
        Preconditions.checkArgument((this.from != null ? 1 : 0) != 0, (Object)("from is mandatory but missing for segment #" + this.nr));
        this.from.validate();
        Preconditions.checkArgument((this.to != null ? 1 : 0) != 0, (Object)("to is mandatory but missing for segment #" + this.nr));
        this.to.validate();
        Preconditions.checkArgument((this.distanceMeters != null ? 1 : 0) != 0, (Object)("distanceMeters is mandatory but missing for segment #" + this.nr));
        Preconditions.checkArgument((this.durationSeconds != null ? 1 : 0) != 0, (Object)("durationSeconds is mandatory but missing for segment #" + this.nr));
        Preconditions.checkArgument((this.modeOfTransport != null ? 1 : 0) != 0, (Object)("modeOfTransport is mandatory but missing for segment #" + this.nr));
        Preconditions.checkArgument((this.startTime != null ? 1 : 0) != 0, (Object)("startTime is mandatory but missing for segment #" + this.nr));
        Preconditions.checkArgument((this.endTime != null ? 1 : 0) != 0, (Object)("endTime is mandatory but missing for segment #" + this.nr));
        this.intermediateStops.forEach(s -> s.validate());
        this.boundingBox.ifPresent(b -> b.validate());
        this.geometryGeoJson.ifPresent(g -> g.validate());
        this.geometryGeoJsonEdges.ifPresent(g -> g.validate());
        this.navigationInstructions.forEach(i -> i.validate());
        try {
            Preconditions.checkArgument((this.nr > 0 ? 1 : 0) != 0, (String)"nr must be > 0, but was %s", (Object[])new Object[]{this.nr});
            Preconditions.checkArgument((this.distanceMeters >= 0 ? 1 : 0) != 0, (String)"distanceMeters must be >= 0, but was %s for segment #%s", (Object[])new Object[]{this.distanceMeters, this.nr});
            Preconditions.checkArgument((this.durationSeconds >= 0 ? 1 : 0) != 0, (String)"durationSeconds must be >= 0, but was %s for segment #%s", (Object[])new Object[]{this.durationSeconds, this.nr});
            Preconditions.checkArgument((this.alightingSeconds.orElse(0) + this.boardingSeconds.orElse(0) <= this.durationSeconds ? 1 : 0) != 0, (String)"boarding+alighting seconds must be equal to or smaller than the total duration for segment #%s", (Object[])new Object[]{this.nr});
            Preconditions.checkArgument((!this.endTime.isBefore(this.startTime) ? 1 : 0) != 0, (String)"startTime must be <= endTime for segment #%s", (Object[])new Object[]{this.nr});
            long durationBetweenTimestamps = Duration.between(this.startTime, this.endTime).getSeconds();
            Preconditions.checkArgument(((long)this.durationSeconds.intValue() == durationBetweenTimestamps ? 1 : 0) != 0, (String)"durationSeconds does not match seconds between start & end time: %s!=%s for segment #%s", (Object[])new Object[]{this.durationSeconds, durationBetweenTimestamps, this.nr});
            String error = "timestamps of intermediate stops must fall in interval between start & end for segment #" + this.nr;
            for (IntermediateStop stop : this.intermediateStops) {
                Preconditions.checkArgument((boolean)Utils.isBetween(this.startTime, stop.getPlannedArrivalTimeAsZonedDateTime(), this.endTime), (Object)error);
                Preconditions.checkArgument((boolean)Utils.isBetween(this.startTime, stop.getPlannedDepartureTimeAsZonedDateTime(), this.endTime), (Object)error);
                Preconditions.checkArgument((boolean)Utils.isBetween(this.startTime, stop.getEstimatedArrivalTimeAsZonedDateTime(), this.endTime), (Object)error);
                Preconditions.checkArgument((boolean)Utils.isBetween(this.startTime, stop.getEstimatedDepartureTimeAsZonedDateTime(), this.endTime), (Object)error);
            }
            boolean geometryPresent = this.geometryEncodedPolyLine.isPresent() || this.geometryGeoJson.isPresent() || this.geometryGeoJsonEdges.isPresent();
            Preconditions.checkArgument((boolean)geometryPresent, (String)"at least one geometry must be present for segment #%s", (Object[])new Object[]{this.nr});
        }
        catch (IllegalArgumentException e) {
            if (strongValidation) {
                throw e;
            }
            LOGGER.warn(e.getMessage());
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("%d: %s %dm %ds (%s ", this.nr, this.modeOfTransport.toString(), this.distanceMeters, this.durationSeconds, Utils.getShortStringDate(this.startTime)));
        if (this.boardingSeconds.isPresent() && this.boardingSeconds.get() > 0) {
            builder.append(String.format("start: %s, departure: %s, ", Utils.getShortStringTime(this.startTime), Utils.getShortStringTime(this.startTime.plus(this.boardingSeconds.get().intValue(), ChronoUnit.SECONDS))));
        } else {
            builder.append(String.format("start: %s, ", Utils.getShortStringTime(this.startTime)));
        }
        if (this.alightingSeconds.isPresent() && this.alightingSeconds.get() > 0) {
            builder.append(String.format("alighting: %s, end: %s", Utils.getShortStringTime(this.endTime.minus(this.alightingSeconds.get().intValue(), ChronoUnit.SECONDS)), Utils.getShortStringTime(this.endTime)));
        } else {
            builder.append(String.format("end: %s", Utils.getShortStringTime(this.endTime)));
        }
        builder.append(")");
        return builder.toString();
    }
}

