/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.ariadne.routeformat;

import at.ac.ait.ariadne.routeformat.Constants;
import at.ac.ait.ariadne.routeformat.ModeOfTransport;
import at.ac.ait.ariadne.routeformat.RequestModeOfTransport;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Set;
import java.util.TreeSet;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class RequestPTModeOfTransport
extends RequestModeOfTransport<RequestPTModeOfTransport> {
    private Set<Constants.DetailedModeOfTransportType> excludedPublicTransportModes = new TreeSet<Constants.DetailedModeOfTransportType>();

    @JsonProperty
    public Set<Constants.DetailedModeOfTransportType> getExcludedPublicTransportModes() {
        return this.excludedPublicTransportModes;
    }

    public RequestPTModeOfTransport setExcludedPublicTransportModes(Set<Constants.DetailedModeOfTransportType> excludedPublicTransportModes) {
        this.excludedPublicTransportModes = new TreeSet<Constants.DetailedModeOfTransportType>(excludedPublicTransportModes);
        return this;
    }

    public static RequestPTModeOfTransport createMinimal(ModeOfTransport modeOfTransport) {
        return (RequestPTModeOfTransport)new RequestPTModeOfTransport().setModeOfTransport(modeOfTransport);
    }

    @Override
    public void validate() {
        super.validate();
        Preconditions.checkArgument((boolean)this.modeOfTransport.getGeneralizedType().equals((Object)Constants.GeneralizedModeOfTransportType.PUBLIC_TRANSPORT), (Object)"only public transport allowed");
        for (Constants.DetailedModeOfTransportType mot : this.excludedPublicTransportModes) {
            Preconditions.checkArgument((mot.getGeneralizedType() == Constants.GeneralizedModeOfTransportType.PUBLIC_TRANSPORT ? 1 : 0) != 0, (Object)"only detailed public transport mots allowed when excluding public transport");
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.excludedPublicTransportModes == null ? 0 : this.excludedPublicTransportModes.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequestPTModeOfTransport other = (RequestPTModeOfTransport)obj;
        return !(this.excludedPublicTransportModes == null ? other.excludedPublicTransportModes != null : !this.excludedPublicTransportModes.equals(other.excludedPublicTransportModes));
    }

    @Override
    public String toString() {
        return super.toString() + " -> RequestPTModeOfTransport [excludedPublicTransportModes=" + this.excludedPublicTransportModes + "]";
    }
}

