/*
 * Decompiled with CFR 0.152.
 */
package ascelion.flyway.csv;

import ascelion.flyway.csv.LineProvider;
import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.enums.CSVReaderNullFieldIndicator;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.flywaydb.core.api.FlywayException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class StatementBuilder {
    private static final Logger L = LoggerFactory.getLogger(StatementBuilder.class);
    private final Connection db;
    private final String table;
    private final LineProvider lp;
    private final Map<String, List<String>> references;
    private final CSVParser parser = new CSVParserBuilder().withFieldAsNull(CSVReaderNullFieldIndicator.EMPTY_SEPARATORS).build();

    public Statement createBatch(String location) throws SQLException, IOException {
        String line;
        String[] columns = this.parser.parseLine(this.lp.nextLine());
        if (columns == null) {
            throw new FlywayException("Cannot parse header: " + location);
        }
        List[] fkeys = new List[columns.length];
        for (int k = 0; k < columns.length; ++k) {
            columns[k] = columns[k].trim();
            int pipeIx = columns[k].indexOf(124);
            if (pipeIx < 0) continue;
            String ftable = columns[k].substring(pipeIx + 1);
            fkeys[k] = this.references.get(ftable);
            if (fkeys[k] == null) {
                throw new FlywayException(String.format("Table %s has not been imported in this session", ftable));
            }
            columns[k] = columns[k].substring(0, pipeIx);
        }
        int[] types = this.determineTypes(this.db, columns);
        String insertSQL = Arrays.stream(columns).map(String::trim).collect(Collectors.joining(", ", "INSERT INTO " + this.table + "(", ")"));
        String valuesSQL = IntStream.range(0, columns.length).mapToObj(n -> "?").collect(Collectors.joining(", ", "VALUES(", ")"));
        L.debug("Generated SQL\n\n{}\n{}\n", (Object)insertSQL, (Object)valuesSQL);
        PreparedStatement statement = this.db.prepareStatement(insertSQL + valuesSQL, 1);
        int row = 0;
        while ((line = this.lp.nextLine()) != null) {
            String[] values = this.parser.parseLine(line.trim());
            ArrayList<String> logged = new ArrayList<String>();
            for (int col = 0; col < columns.length; ++col) {
                String value = this.columnValue(row, col < columns.length ? values[col] : null, fkeys[col]);
                logged.add(value);
                if (value != null) {
                    statement.setObject(col + 1, (Object)value, types[col]);
                    continue;
                }
                statement.setNull(col + 1, 0);
            }
            if (L.isTraceEnabled()) {
                L.trace("INSERT: {}", logged);
            }
            statement.addBatch();
            ++row;
        }
        return statement;
    }

    private String columnValue(int row, String value, List<String> fkeys) {
        if (fkeys == null) {
            return value;
        }
        return value == null ? fkeys.get(row) : fkeys.get(Integer.parseInt(value));
    }

    private int[] determineTypes(Connection db, String[] columns) throws SQLException {
        String sql = Arrays.stream(columns).collect(Collectors.joining(",", "SELECT ", " FROM " + this.table + " WHERE 0 = 1"));
        ResultSet rs = db.createStatement().executeQuery(sql);
        ResultSetMetaData md = rs.getMetaData();
        int[] types = new int[columns.length];
        for (int col = 0; col < columns.length; ++col) {
            types[col] = md.getColumnType(col + 1);
        }
        return types;
    }

    @ConstructorProperties(value={"db", "table", "lp", "references"})
    @Generated
    public StatementBuilder(Connection db, String table, LineProvider lp, Map<String, List<String>> references) {
        this.db = db;
        this.table = table;
        this.lp = lp;
        this.references = references;
    }
}

