/*
 * Decompiled with CFR 0.152.
 */
package ascelion.flyway.csv;

import ascelion.flyway.csv.CSVResolvedMigrationBase;
import java.util.Collection;
import java.util.stream.Collectors;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.resolver.Context;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.flywaydb.core.api.resolver.ResolvedMigration;
import org.flywaydb.core.internal.resolver.MigrationInfoHelper;
import org.flywaydb.core.internal.resource.Resource;
import org.flywaydb.core.internal.util.Pair;

public abstract class CSVMigrationResolverBase<R extends Resource>
implements MigrationResolver {
    private static String[] SUFFIXES = new String[]{".csv", ".CSV"};

    public final Collection<ResolvedMigration> resolveMigrations(Context context) {
        Configuration cf = context.getConfiguration();
        return this.getResources(cf, SUFFIXES).stream().map(res -> this.createMigration(cf, res)).collect(Collectors.toList());
    }

    protected abstract Collection<R> getResources(Configuration var1, String ... var2);

    protected abstract CSVResolvedMigrationBase<R> newMigration(R var1, MigrationVersion var2, String var3, String var4);

    private CSVResolvedMigrationBase<R> createMigration(Configuration cf, R res) {
        String desc;
        String table;
        Pair mi = MigrationInfoHelper.extractVersionAndDescription((String)res.getFilename(), (String)cf.getSqlMigrationPrefix(), (String)cf.getSqlMigrationSeparator(), (String[])SUFFIXES, (boolean)false);
        String right = (String)mi.getRight();
        int sepIx = right.indexOf(cf.getSqlMigrationSeparator());
        if (sepIx < 0) {
            table = right;
            desc = "IMPORT TABLE " + table;
        } else {
            table = right.substring(0, sepIx);
            desc = right.substring(sepIx + 1);
        }
        return this.newMigration(res, (MigrationVersion)mi.getLeft(), table, desc);
    }
}

