/*
 * Decompiled with CFR 0.152.
 */
package ascelion.flyway.csv;

import ascelion.flyway.csv.LineProvider;
import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.enums.CSVReaderNullFieldIndicator;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;

final class StatementBuilder {
    private final Connection db;
    private final String table;
    private final LineProvider rd;
    private final CSVParser ps = new CSVParserBuilder().withFieldAsNull(CSVReaderNullFieldIndicator.EMPTY_SEPARATORS).build();

    public Statement createBatch() throws SQLException, IOException {
        String line;
        String[] columns = this.ps.parseLine(this.rd.nextLine());
        if (columns == null) {
            return null;
        }
        int[] types = this.determineTypes(this.db, columns);
        String sql1 = Arrays.stream(columns).map(String::trim).collect(Collectors.joining(",", "INSERT INTO " + this.table + "(", ")"));
        String sql2 = IntStream.range(0, columns.length).mapToObj(n -> "?").collect(Collectors.joining(",", "VALUES(", ")"));
        PreparedStatement statement = this.db.prepareStatement(sql1 + sql2);
        while ((line = this.rd.nextLine()) != null) {
            String[] values = this.ps.parseLine(line);
            for (int col = 0; col < values.length; ++col) {
                if (values[col] != null) {
                    statement.setObject(col + 1, (Object)values[col].trim(), types[col]);
                    continue;
                }
                statement.setNull(col + 1, 0);
            }
            for (int k = values.length; k < columns.length; ++k) {
                statement.setNull(k + 1, 0);
            }
            statement.addBatch();
        }
        return statement;
    }

    private int[] determineTypes(Connection db, String[] columns) throws SQLException {
        String sql = Arrays.stream(columns).collect(Collectors.joining(",", "SELECT ", " FROM " + this.table + " WHERE 0 = 1"));
        ResultSet rs = db.createStatement().executeQuery(sql);
        ResultSetMetaData md = rs.getMetaData();
        int[] types = new int[columns.length];
        for (int col = 0; col < columns.length; ++col) {
            types[col] = md.getColumnType(col + 1);
        }
        return types;
    }

    @ConstructorProperties(value={"db", "table", "rd"})
    @Generated
    public StatementBuilder(Connection db, String table, LineProvider rd) {
        this.db = db;
        this.table = table;
        this.rd = rd;
    }
}

