/*
 * Decompiled with CFR 0.152.
 */
package ascelion.flyway.csv;

import ascelion.flyway.csv.CSVMigrationExecutor;
import ascelion.flyway.csv.LineProvider;
import ascelion.flyway.csv.StatementBuilder;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import lombok.Generated;
import org.flywaydb.core.api.MigrationType;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.resolver.ResolvedMigration;
import org.flywaydb.core.internal.resource.Resource;

public abstract class CSVResolvedMigrationBase<R extends Resource>
implements ResolvedMigration {
    private final R resource;
    private final MigrationVersion version;
    private final String table;
    private final String description;
    private final int checksum;
    private final CSVMigrationExecutor executor;

    CSVResolvedMigrationBase(R resource, MigrationVersion version, String table, String description, int checksum) {
        this.resource = resource;
        this.version = version;
        this.table = table;
        this.description = description;
        this.checksum = checksum;
        this.executor = new CSVMigrationExecutor(this);
    }

    public final String getScript() {
        return this.resource.getRelativePath();
    }

    public final Integer getChecksum() {
        return this.checksum;
    }

    public final MigrationType getType() {
        return MigrationType.JDBC;
    }

    public final String getPhysicalLocation() {
        return this.resource.getAbsolutePathOnDisk();
    }

    protected final Statement statement(Connection db) throws SQLException, IOException {
        try (LineProvider rd = this.openResource();){
            StatementBuilder sb = new StatementBuilder(db, this.table, rd);
            Statement statement = sb.createBatch();
            return statement;
        }
    }

    protected abstract LineProvider openResource() throws IOException;

    @Generated
    public R getResource() {
        return this.resource;
    }

    @Generated
    public MigrationVersion getVersion() {
        return this.version;
    }

    @Generated
    public String getTable() {
        return this.table;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public CSVMigrationExecutor getExecutor() {
        return this.executor;
    }
}

