/*
 * Decompiled with CFR 0.152.
 */
package ascelion.flyway.cdi;

import ascelion.cdi.literal.AnyLiteral;
import ascelion.flyway.api.FlywayMigration;
import ascelion.flyway.java.JavaResolvedMigration;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.flywaydb.core.api.migration.JavaMigration;
import org.flywaydb.core.api.resolver.Context;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.flywaydb.core.api.resolver.ResolvedMigration;

final class CdiMigrationResolver
implements MigrationResolver {
    private final BeanManager bm;
    private final Set<String> packages;

    CdiMigrationResolver(BeanManager bm, FlywayMigration fm) {
        this.bm = bm;
        if (fm != null) {
            Stream<String> s1 = Arrays.stream(fm.packages());
            Stream<String> s2 = Arrays.stream(fm.packageClasses()).map(Class::getPackage).map(Package::getName);
            this.packages = Stream.concat(s1, s2).collect(Collectors.toSet());
        } else {
            this.packages = Collections.emptySet();
        }
    }

    public Collection<ResolvedMigration> resolveMigrations(Context context) {
        return this.bm.getBeans(JavaMigration.class, new Annotation[]{AnyLiteral.INSTANCE}).stream().filter(this::filterByPackage).map(this::createMigration).map(JavaResolvedMigration::new).collect(Collectors.toList());
    }

    private JavaMigration createMigration(Bean<?> bean) {
        return (JavaMigration)bean.create(this.bm.createCreationalContext(null));
    }

    private boolean filterByPackage(Bean<?> bean) {
        return this.packages.isEmpty() || this.packages.contains(bean.getBeanClass().getPackage().getName());
    }
}

